/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import dev.mccue.guava.base.Joiner;
import dev.mccue.guava.base.Optional;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Predicate;
import dev.mccue.guava.base.Splitter;
import dev.mccue.guava.collect.ImmutableList;
import dev.mccue.guava.collect.ImmutableSet;
import dev.mccue.guava.collect.Lists;
import dev.mccue.guava.graph.SuccessorsFunction;
import dev.mccue.guava.graph.Traverser;
import dev.mccue.guava.hash.HashCode;
import dev.mccue.guava.hash.HashFunction;
import dev.mccue.guava.io.ByteProcessor;
import dev.mccue.guava.io.ByteSink;
import dev.mccue.guava.io.ByteSource;
import dev.mccue.guava.io.ByteStreams;
import dev.mccue.guava.io.CharSink;
import dev.mccue.guava.io.CharSource;
import dev.mccue.guava.io.Closer;
import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.io.FileWriteMode;
import dev.mccue.guava.io.LineProcessor;
import dev.mccue.guava.io.ParametricNullness;
import dev.mccue.guava.io.TempFileCreator;
import dev.mccue.jsr305.CheckForNull;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ElementTypesAreNonnullByDefault
public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        public Iterable<File> successors(File file) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                return Collections.unmodifiableList(Arrays.asList(files));
            }
            return ImmutableList.of();
        }
    };

    private Files() {
    }

    public static BufferedReader newReader(File file, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter newWriter(File file, Charset charset) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... modes) {
        return new FileByteSink(file, modes);
    }

    public static CharSource asCharSource(File file, Charset charset) {
        return Files.asByteSource(file).asCharSource(charset);
    }

    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... modes) {
        return Files.asByteSink(file, modes).asCharSink(charset);
    }

    public static byte[] toByteArray(File file) throws IOException {
        return Files.asByteSource(file).read();
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSource(file, charset).read()", imports={"dev.mccue.guava.io.Files"})
    public static String toString(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).read();
    }

    public static void write(byte[] from, File to) throws IOException {
        Files.asByteSink(to, new FileWriteMode[0]).write(from);
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSink(to, charset).write(from)", imports={"dev.mccue.guava.io.Files"})
    public static void write(CharSequence from, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, new FileWriteMode[0]).write(from);
    }

    public static void copy(File from, OutputStream to) throws IOException {
        Files.asByteSource(from).copyTo(to);
    }

    public static void copy(File from, File to) throws IOException {
        Preconditions.checkArgument((!from.equals(to) ? 1 : 0) != 0, (String)"Source %s and destination %s must be different", (Object)from, (Object)to);
        Files.asByteSource(from).copyTo(Files.asByteSink(to, new FileWriteMode[0]));
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSource(from, charset).copyTo(to)", imports={"dev.mccue.guava.io.Files"})
    public static void copy(File from, Charset charset, Appendable to) throws IOException {
        Files.asCharSource(from, charset).copyTo(to);
    }

    @Deprecated
    @InlineMe(replacement="Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from)", imports={"dev.mccue.guava.io.FileWriteMode", "dev.mccue.guava.io.Files"})
    public static void append(CharSequence from, File to, Charset charset) throws IOException {
        Files.asCharSink(to, charset, FileWriteMode.APPEND).write(from);
    }

    public static boolean equal(File file1, File file2) throws IOException {
        Preconditions.checkNotNull((Object)file1);
        Preconditions.checkNotNull((Object)file2);
        if (file1 == file2 || file1.equals(file2)) {
            return true;
        }
        long len1 = file1.length();
        long len2 = file2.length();
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return Files.asByteSource(file1).contentEquals(Files.asByteSource(file2));
    }

    @Deprecated
    public static File createTempDir() {
        return TempFileCreator.INSTANCE.createTempDir();
    }

    public static void touch(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to update modification time of " + file);
        }
    }

    public static void createParentDirs(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    public static void move(File from, File to) throws IOException {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkArgument((!from.equals(to) ? 1 : 0) != 0, (String)"Source %s and destination %s must be different", (Object)from, (Object)to);
        if (!from.renameTo(to)) {
            Files.copy(from, to);
            if (!from.delete()) {
                if (!to.delete()) {
                    throw new IOException("Unable to delete " + to);
                }
                throw new IOException("Unable to delete " + from);
            }
        }
    }

    @Deprecated
    @CheckForNull
    @InlineMe(replacement="Files.asCharSource(file, charset).readFirstLine()", imports={"dev.mccue.guava.io.Files"})
    public static String readFirstLine(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readFirstLine();
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    @Deprecated
    @ParametricNullness
    @InlineMe(replacement="Files.asCharSource(file, charset).readLines(callback)", imports={"dev.mccue.guava.io.Files"})
    @CanIgnoreReturnValue
    public static <T> T readLines(File file, Charset charset, LineProcessor<T> callback) throws IOException {
        return Files.asCharSource(file, charset).readLines(callback);
    }

    @Deprecated
    @ParametricNullness
    @InlineMe(replacement="Files.asByteSource(file).read(processor)", imports={"dev.mccue.guava.io.Files"})
    @CanIgnoreReturnValue
    public static <T> T readBytes(File file, ByteProcessor<T> processor) throws IOException {
        return Files.asByteSource(file).read(processor);
    }

    @Deprecated
    @InlineMe(replacement="Files.asByteSource(file).hash(hashFunction)", imports={"dev.mccue.guava.io.Files"})
    public static HashCode hash(File file, HashFunction hashFunction) throws IOException {
        return Files.asByteSource(file).hash(hashFunction);
    }

    public static MappedByteBuffer map(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        return Files.map(file, FileChannel.MapMode.READ_ONLY);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mode) throws IOException {
        return Files.mapInternal(file, mode, -1L);
    }

    public static MappedByteBuffer map(File file, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"size (%s) may not be negative", (long)size);
        return Files.mapInternal(file, mode, size);
    }

    private static MappedByteBuffer mapInternal(File file, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)mode);
        try (Closer closer = Closer.create();){
            RandomAccessFile raf = closer.register(new RandomAccessFile(file, mode == FileChannel.MapMode.READ_ONLY ? "r" : "rw"));
            FileChannel channel = closer.register(raf.getChannel());
            MappedByteBuffer mappedByteBuffer = channel.map(mode, 0L, size == -1L ? channel.size() : size);
            return mappedByteBuffer;
        }
    }

    public static String simplifyPath(String pathname) {
        Preconditions.checkNotNull((Object)pathname);
        if (pathname.length() == 0) {
            return ".";
        }
        Iterable components = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)pathname);
        ArrayList<String> path = new ArrayList<String>();
        Iterator iterator = components.iterator();
        block8: while (iterator.hasNext()) {
            String component;
            switch (component = (String)iterator.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (path.size() > 0 && !((String)path.get(path.size() - 1)).equals("..")) {
                        path.remove(path.size() - 1);
                        continue block8;
                    }
                    path.add("..");
                    continue block8;
                }
            }
            path.add(component);
        }
        Object result = Joiner.on((char)'/').join(path);
        if (pathname.charAt(0) == '/') {
            result = "/" + (String)result;
        }
        while (((String)result).startsWith("/../")) {
            result = ((String)result).substring(3);
        }
        if (((String)result).equals("/..")) {
            result = "/";
        } else if ("".equals(result)) {
            result = ".";
        }
        return result;
    }

    public static String getFileExtension(String fullName) {
        Preconditions.checkNotNull((Object)fullName);
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(String file) {
        Preconditions.checkNotNull((Object)file);
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
        }

        @Override
        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of((Object)this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public long size() throws IOException {
            if (!this.file.isFile()) {
                throw new FileNotFoundException(this.file.toString());
            }
            return this.file.length();
        }

        @Override
        public byte[] read() throws IOException {
            try (Closer closer = Closer.create();){
                FileInputStream in = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray(in, in.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            return "Files.asByteSource(" + this.file + ")";
        }
    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... modes) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
            this.modes = ImmutableSet.copyOf((Object[])modes);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            return "Files.asByteSink(" + this.file + ", " + this.modes + ")";
        }
    }

    private static enum FilePredicate implements Predicate<File>
    {
        IS_DIRECTORY{

            public boolean apply(File file) {
                return file.isDirectory();
            }

            public String toString() {
                return "Files.isDirectory()";
            }
        }
        ,
        IS_FILE{

            public boolean apply(File file) {
                return file.isFile();
            }

            public String toString() {
                return "Files.isFile()";
            }
        };

    }
}

