/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.io;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.io.CharStreams;
import dev.mccue.guava.io.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.io.Java8Compatibility;
import dev.mccue.guava.io.LineBuffer;
import dev.mccue.jsr305.CheckForNull;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
public final class LineReader {
    private final Readable readable;
    @CheckForNull
    private final Reader reader;
    private final CharBuffer cbuf = CharStreams.createBuffer();
    private final char[] buf = this.cbuf.array();
    private final Queue<String> lines = new ArrayDeque<String>();
    private final LineBuffer lineBuf = new LineBuffer(){

        @Override
        protected void handleLine(String line, String end) {
            LineReader.this.lines.add(line);
        }
    };

    public LineReader(Readable readable) {
        this.readable = (Readable)Preconditions.checkNotNull((Object)readable);
        this.reader = readable instanceof Reader ? (Reader)readable : null;
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public String readLine() throws IOException {
        while (this.lines.peek() == null) {
            int read;
            Java8Compatibility.clear(this.cbuf);
            int n = read = this.reader != null ? this.reader.read(this.buf, 0, this.buf.length) : this.readable.read(this.cbuf);
            if (read == -1) {
                this.lineBuf.finish();
                break;
            }
            this.lineBuf.add(this.buf, 0, read);
        }
        return this.lines.poll();
    }
}

