/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.jdk.httpserver;

import com.sun.net.httpserver.HttpExchange;
import dev.mccue.jdk.httpserver.Body;
import dev.mccue.jdk.httpserver.ResponseLength;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class HttpExchangeUtils {
    private HttpExchangeUtils() {
    }

    public static void sendResponseHeaders(HttpExchange exchange, int rCode, ResponseLength responseLength) throws IOException {
        exchange.sendResponseHeaders(rCode, responseLength.value);
    }

    public static void sendResponse(HttpExchange exchange, int rCode, Body body) throws IOException {
        body.defaultContentType().ifPresent(contentType -> exchange.getResponseHeaders().putIfAbsent("Content-Type", List.of(contentType)));
        HttpExchangeUtils.sendResponseHeaders(exchange, rCode, body.responseLength());
        try (OutputStream os = exchange.getResponseBody();){
            body.writeTo(os);
        }
    }
}

