/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.jdk.httpserver;

import dev.mccue.jdk.httpserver.ByteArrayBody;
import dev.mccue.jdk.httpserver.EmptyBody;
import dev.mccue.jdk.httpserver.InputStreamBody;
import dev.mccue.jdk.httpserver.ResponseLength;
import dev.mccue.jdk.httpserver.StringBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Optional;

public interface Body {
    public void writeTo(OutputStream var1) throws IOException;

    default public ResponseLength responseLength() {
        return ResponseLength.unknown();
    }

    default public Optional<String> defaultContentType() {
        return Optional.empty();
    }

    public static Body of(String value) {
        return new StringBody(value);
    }

    public static Body of(String value, Charset charset) {
        return new StringBody(value, charset);
    }

    public static Body of(byte[] value) {
        return new ByteArrayBody(value);
    }

    public static Body of(InputStream inputStream) {
        return new InputStreamBody(inputStream);
    }

    public static Body of(InputStream inputStream, ResponseLength responseLength) {
        return new InputStreamBody(inputStream, responseLength);
    }

    public static Body empty() {
        return EmptyBody.INSTANCE;
    }
}

