/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.jdk.httpserver;

import dev.mccue.jdk.httpserver.Body;
import dev.mccue.jdk.httpserver.ResponseLength;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

final class InputStreamBody
implements Body {
    private final InputStream value;
    private final ResponseLength responseLength;

    InputStreamBody(InputStream value) {
        this(value, ResponseLength.unknown());
    }

    InputStreamBody(InputStream value, ResponseLength responseLength) {
        this.value = Objects.requireNonNull(value);
        this.responseLength = Objects.requireNonNull(responseLength);
    }

    @Override
    public ResponseLength responseLength() {
        return this.responseLength;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.value.transferTo(outputStream);
    }

    public String toString() {
        return "InputStreamBody[value=" + String.valueOf(this.value) + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof InputStreamBody)) return false;
        InputStreamBody i = (InputStreamBody)obj;
        if (!this.value.equals(i.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

