/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.jdk.httpserver;

import dev.mccue.jdk.httpserver.Body;
import dev.mccue.jdk.httpserver.ResponseLength;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class StringBody
implements Body {
    private final String value;
    private final byte[] bytes;

    StringBody(String value, Charset charset) {
        this.value = Objects.requireNonNull(value);
        this.bytes = value.getBytes(charset);
    }

    StringBody(String value) {
        this(value, StandardCharsets.UTF_8);
    }

    @Override
    public ResponseLength responseLength() {
        return ResponseLength.known(this.bytes.length);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes);
    }

    public String toString() {
        return "StringBody[value=" + this.value + "]";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof StringBody)) return false;
        StringBody s = (StringBody)obj;
        if (!this.value.equals(s.value)) return false;
        return true;
    }
}

