/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonBoolean;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.JsonNull;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonObject;
import dev.mccue.json.JsonReadException;
import dev.mccue.json.JsonReader;
import dev.mccue.json.JsonWriteable;
import dev.mccue.json.internal.ArrayBuilderImpl;
import dev.mccue.json.internal.ArrayImpl;
import dev.mccue.json.internal.BigDecimalImpl;
import dev.mccue.json.internal.BigIntegerImpl;
import dev.mccue.json.internal.DoubleImpl;
import dev.mccue.json.internal.JsonReaderMethods;
import dev.mccue.json.internal.JsonWriter;
import dev.mccue.json.internal.LongImpl;
import dev.mccue.json.internal.ObjectBuilder;
import dev.mccue.json.internal.ObjectImpl;
import dev.mccue.json.internal.StringImpl;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Json
extends Serializable,
JsonEncodable,
JsonWriteable {
    public static Json of(JsonEncodable value) {
        return value == null ? JsonNull.instance() : value.toJson();
    }

    public static Json of(BigDecimal value) {
        return value == null ? JsonNull.instance() : new BigDecimalImpl(value);
    }

    public static Json of(double value) {
        return new DoubleImpl(value);
    }

    public static Json of(long value) {
        return new LongImpl(value);
    }

    public static Json of(float value) {
        return new DoubleImpl(value);
    }

    public static Json of(int value) {
        return new LongImpl(value);
    }

    public static Json of(Double value) {
        return value == null ? JsonNull.instance() : new DoubleImpl(value);
    }

    public static Json of(Long value) {
        return value == null ? JsonNull.instance() : new LongImpl(value);
    }

    public static Json of(Float value) {
        return value == null ? JsonNull.instance() : new DoubleImpl(value.floatValue());
    }

    public static Json of(Integer value) {
        return value == null ? JsonNull.instance() : new LongImpl(value.intValue());
    }

    public static Json of(BigInteger value) {
        return value == null ? JsonNull.instance() : new BigIntegerImpl(value);
    }

    public static Json of(String value) {
        return value == null ? JsonNull.instance() : new StringImpl(value);
    }

    public static Json ofNull() {
        return JsonNull.instance();
    }

    public static Json ofTrue() {
        return JsonBoolean.of(true);
    }

    public static Json ofFalse() {
        return JsonBoolean.of(false);
    }

    public static Json of(boolean b) {
        return JsonBoolean.of(b);
    }

    public static Json of(Boolean b) {
        return b == null ? JsonNull.instance() : JsonBoolean.of((boolean)b);
    }

    public static Json of(Collection<? extends JsonEncodable> jsonList) {
        return jsonList == null ? JsonNull.instance() : new ArrayImpl(jsonList.stream().map(json -> json == null ? JsonNull.instance() : json.toJson()).toList());
    }

    public static Json of(Map<String, ? extends JsonEncodable> jsonMap) {
        return jsonMap == null ? JsonNull.instance() : new ObjectImpl(jsonMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> entry.getValue() == null ? JsonNull.instance() : ((JsonEncodable)entry.getValue()).toJson())));
    }

    public static JsonObject.Builder objectBuilder() {
        return JsonObject.builder();
    }

    public static JsonObject.Builder objectBuilder(Map<String, ? extends JsonEncodable> object) {
        if (object instanceof JsonObject) {
            JsonObject o = (JsonObject)object;
            return new ObjectBuilder(new HashMap<String, Json>(o));
        }
        return new ObjectBuilder(new HashMap<String, Json>(object.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Json.of((JsonEncodable)entry.getValue())))));
    }

    public static JsonArray.Builder arrayBuilder() {
        return JsonArray.builder();
    }

    public static JsonArray.Builder arrayBuilder(Collection<? extends JsonEncodable> object) {
        if (object instanceof JsonArray) {
            JsonArray o = (JsonArray)object;
            return new ArrayBuilderImpl(new ArrayList<Json>(o));
        }
        return new ArrayBuilderImpl(new ArrayList<Json>(object.stream().map(Json::of).toList()));
    }

    public static JsonArray emptyArray() {
        return ArrayImpl.EMPTY;
    }

    public static JsonObject emptyObject() {
        return ObjectImpl.EMPTY;
    }

    @Override
    default public Json toJson() {
        return this;
    }

    public static Json readString(CharSequence jsonText) throws JsonReadException {
        return Json.readString(jsonText, new ReadOptions());
    }

    public static Json readString(CharSequence jsonText, ReadOptions options) throws JsonReadException {
        try {
            return JsonReaderMethods.read(new PushbackReader(new StringReader(jsonText.toString()), 64), options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Json read(Reader reader, ReadOptions options) throws IOException, JsonReadException {
        return JsonReaderMethods.read(new PushbackReader(reader, 64), options);
    }

    public static Json read(Reader reader) throws IOException, JsonReadException {
        return Json.read(reader, new ReadOptions());
    }

    public static JsonReader reader(Reader reader, ReadOptions options) {
        PushbackReader pushbackReader = new PushbackReader(reader, 64);
        return () -> {
            try {
                return JsonReaderMethods.read(pushbackReader, options);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static JsonReader reader(Reader reader) {
        return Json.reader(reader, new ReadOptions().withEOFBehavior(EOFBehavior.RETURN_NULL));
    }

    public static void readStream(Reader reader, ValueHandler handler, StreamReadOptions options) throws IOException, JsonReadException {
        JsonReaderMethods.readStream(new PushbackReader(reader, 64), false, options, handler);
    }

    public static void readStream(Reader reader, ValueHandler handler) throws IOException, JsonReadException {
        JsonReaderMethods.readStream(new PushbackReader(reader, 64), false, new StreamReadOptions(), handler);
    }

    public static String writeString(Json json) {
        return Json.writeString(json, new WriteOptions());
    }

    public static String writeString(Json json, WriteOptions options) {
        StringWriter sw = new StringWriter();
        try {
            Json.write(json, sw, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sw.toString();
    }

    public static void write(Json json, Writer writer, WriteOptions options) throws IOException {
        new JsonWriter().write(json, writer, options);
    }

    public static void write(Json json, Writer writer) throws IOException {
        new JsonWriter().write(json, writer, new WriteOptions());
    }

    public record ReadOptions(EOFBehavior eofBehavior, boolean useBigDecimals) {
        public ReadOptions {
            Objects.requireNonNull(eofBehavior, "eofBehavior must not be null");
        }

        public ReadOptions() {
            this(EOFBehavior.THROW_EXCEPTION, false);
        }

        public ReadOptions withEOFBehavior(EOFBehavior eofBehavior) {
            return new ReadOptions(eofBehavior, this.useBigDecimals);
        }

        public ReadOptions withUseBigDecimals(boolean useBigDecimals) {
            return new ReadOptions(this.eofBehavior, useBigDecimals);
        }
    }

    public static enum EOFBehavior {
        THROW_EXCEPTION,
        RETURN_NULL;

    }

    public record StreamReadOptions(boolean useBigDecimals) {
        public StreamReadOptions() {
            this(false);
        }

        public StreamReadOptions withUseBigDecimals(boolean useBigDecimals) {
            return new StreamReadOptions(useBigDecimals);
        }
    }

    public static interface ValueHandler {
        public ObjectHandler onObjectStart();

        public ArrayHandler onArrayStart();

        public void onNumber(JsonNumber var1);

        public void onString(String var1);

        public void onNull();

        public void onTrue();

        public void onFalse();
    }

    public record WriteOptions(boolean escapeUnicode, boolean escapeJavascriptSeparators, boolean escapeSlash, int indentation) {
        public WriteOptions {
            if (indentation < 0) {
                throw new IllegalArgumentException("indent must not be less than zero.");
            }
        }

        public WriteOptions() {
            this(true, true, true, 0);
        }

        public WriteOptions withEscapeUnicode(boolean escapeUnicode) {
            return new WriteOptions(escapeUnicode, this.escapeJavascriptSeparators, this.escapeSlash, this.indentation);
        }

        public WriteOptions withEscapeJavascriptSeparators(boolean escapeJavascriptSeparators) {
            return new WriteOptions(this.escapeUnicode, escapeJavascriptSeparators, this.escapeSlash, this.indentation);
        }

        public WriteOptions withEscapeSlash(boolean escapeSlash) {
            return new WriteOptions(this.escapeUnicode, this.escapeJavascriptSeparators, escapeSlash, this.indentation);
        }

        public WriteOptions withIndentation(int indentation) {
            return new WriteOptions(this.escapeUnicode, this.escapeJavascriptSeparators, this.escapeSlash, indentation);
        }
    }

    public static interface ArrayHandler
    extends ValueHandler {
        public void onArrayEnd();
    }

    public static interface ObjectHandler {
        public ValueHandler onField(String var1);

        public void objectEnd();
    }

    public record EventReadOptions(boolean useBigDecimals) {
        public EventReadOptions() {
            this(false);
        }

        public EventReadOptions withUseBigDecimals(boolean useBigDecimals) {
            return new EventReadOptions(useBigDecimals);
        }
    }
}

