/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.internal.ArrayBuilderImpl;
import dev.mccue.json.internal.ArrayImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface JsonArray
extends Json,
List<Json> {
    public static JsonArray of(Json ... values) {
        return JsonArray.of(Arrays.asList(values));
    }

    public static JsonArray of(List<Json> value) {
        Objects.requireNonNull(value, "Json.Array value must be nonnull");
        value.forEach(json -> Objects.requireNonNull(json, "Each value in a Json.Array must be nonnull"));
        return new ArrayImpl(List.copyOf(value));
    }

    public static Builder builder() {
        return new ArrayBuilderImpl();
    }

    public static Builder builder(int initialCapacity) {
        return new ArrayBuilderImpl(initialCapacity);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends JsonEncodable {
        public Builder add(Json var1);

        public Builder addAll(Collection<? extends JsonEncodable> var1);

        default public Builder add(JsonEncodable value) {
            return this.add(Json.of(value));
        }

        default public Builder add(BigDecimal value) {
            return this.add(Json.of(value));
        }

        default public Builder add(double value) {
            return this.add(Json.of(value));
        }

        default public Builder add(long value) {
            return this.add(Json.of(value));
        }

        default public Builder add(float value) {
            return this.add(Json.of(value));
        }

        default public Builder add(int value) {
            return this.add(Json.of(value));
        }

        default public Builder add(Double value) {
            return this.add(Json.of(value));
        }

        default public Builder add(Long value) {
            return this.add(Json.of(value));
        }

        default public Builder add(Float value) {
            return this.add(Json.of(value));
        }

        default public Builder add(Integer value) {
            return this.add(Json.of(value));
        }

        default public Builder add(BigInteger value) {
            return this.add(Json.of(value));
        }

        default public Builder add(String value) {
            return this.add(Json.of(value));
        }

        default public Builder addNull() {
            return this.add(Json.ofNull());
        }

        default public Builder addTrue() {
            return this.add(Json.ofTrue());
        }

        default public Builder addFalse() {
            return this.add(Json.ofFalse());
        }

        default public Builder add(boolean b) {
            return this.add(Json.of(b));
        }

        default public Builder add(Boolean b) {
            return this.add(Json.of(b));
        }

        public JsonArray build();

        @Override
        default public Json toJson() {
            return this.build();
        }
    }
}

