/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class JsonDecodeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    JsonDecodeException() {
    }

    JsonDecodeException(String message) {
        super(message);
    }

    JsonDecodeException(Throwable cause) {
        super(cause);
    }

    public static AtField atField(String fieldName, JsonDecodeException error) {
        return new AtField(fieldName, error);
    }

    public static AtIndex atIndex(int index, JsonDecodeException error) {
        return new AtIndex(index, error);
    }

    public static OneOf oneOf(List<JsonDecodeException> errors) {
        return new OneOf(errors);
    }

    public static Failure of(String message, Json value) {
        return new Failure(message, value);
    }

    public static Failure of(Throwable cause, Json value) {
        return new Failure(cause, value);
    }

    private static String indent(String string) {
        return String.join((CharSequence)"\n    ", string.split("\n"));
    }

    private static String getMessageHelp(JsonDecodeException error, ArrayList<String> context) {
        if (error instanceof AtField) {
            boolean isSimple;
            AtField atField = (AtField)error;
            Object fieldName = atField.fieldName;
            JsonDecodeException err = atField.getCause();
            if (((String)fieldName).isEmpty()) {
                isSimple = false;
            } else {
                isSimple = Character.isAlphabetic(((String)fieldName).charAt(0));
                for (int i = 1; i < ((String)fieldName).length(); ++i) {
                    isSimple = isSimple && (Character.isAlphabetic(((String)fieldName).charAt(i)) || Character.isDigit(((String)fieldName).charAt(i)));
                }
            }
            fieldName = isSimple ? "." + (String)fieldName : "[" + (String)fieldName + "]";
            context.add((String)fieldName);
            return JsonDecodeException.getMessageHelp(err, context);
        }
        if (error instanceof AtIndex) {
            AtIndex atIndex = (AtIndex)error;
            String indexName = "[" + atIndex.index + "]";
            context.add(indexName);
            return JsonDecodeException.getMessageHelp(atIndex.getCause(), context);
        }
        if (error instanceof OneOf) {
            OneOf oneOf = (OneOf)error;
            if (oneOf.errors.isEmpty()) {
                return "Ran into oneOf with no possibilities" + (String)(context.isEmpty() ? "!" : " at json" + String.join((CharSequence)"", context));
            }
            if (oneOf.errors.size() == 1) {
                return JsonDecodeException.getMessageHelp(oneOf.errors.get(0), context);
            }
            String starter = context.isEmpty() ? "oneOf" : "oneOf at json" + String.join((CharSequence)"", context);
            String introduction = starter + " failed in the following " + oneOf.errors.size() + " ways:";
            StringBuilder msg = new StringBuilder(introduction + "\n\n");
            for (int i = 0; i < oneOf.errors.size(); ++i) {
                msg.append("\n\n(");
                msg.append(i + 1);
                msg.append(") ");
                msg.append(JsonDecodeException.indent(JsonDecodeException.getMessage(oneOf.errors.get(i))));
                if (i == oneOf.errors.size() - 1) continue;
                msg.append("\n\n");
            }
            return msg.toString();
        }
        if (error instanceof Failure) {
            Failure failure = (Failure)error;
            String msg = failure.getMessage();
            Json json = failure.value;
            String introduction = context.isEmpty() ? "Problem with the given value:\n\n    " : "Problem with the value at json" + String.join((CharSequence)"", context) + ":\n\n    ";
            return introduction + JsonDecodeException.indent(Json.writeString(json, new Json.WriteOptions().withIndentation(4))) + "\n\n" + msg;
        }
        throw new IllegalStateException();
    }

    protected static String getMessage(JsonDecodeException error) {
        return JsonDecodeException.getMessageHelp(error, new ArrayList<String>());
    }

    public static final class AtField
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final String fieldName;

        private AtField(String fieldName, JsonDecodeException error) {
            super(error);
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            Objects.requireNonNull(error, "error must not be null");
            this.fieldName = fieldName;
        }

        public String fieldName() {
            return this.fieldName;
        }

        @Override
        public String getMessage() {
            return AtField.getMessage(this);
        }

        @Override
        public synchronized JsonDecodeException getCause() {
            return (JsonDecodeException)super.getCause();
        }
    }

    public static final class AtIndex
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final int index;

        private AtIndex(int index, JsonDecodeException error) {
            super(error);
            Objects.requireNonNull(error);
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        @Override
        public String getMessage() {
            return AtIndex.getMessage(this);
        }

        @Override
        public synchronized JsonDecodeException getCause() {
            return (JsonDecodeException)super.getCause();
        }
    }

    public static final class OneOf
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final List<JsonDecodeException> errors;

        private static <T> T throwNotEmpty() {
            throw new IllegalArgumentException("errors must be non-empty");
        }

        private OneOf(List<JsonDecodeException> errors) {
            super(errors.size() > 0 ? (Throwable)errors.get(0) : (Throwable)OneOf.throwNotEmpty());
            Objects.requireNonNull(errors, "errors of errors must not be null");
            errors.forEach(error -> Objects.requireNonNull(error, "every error must not be null"));
            this.errors = List.copyOf(errors);
        }

        public List<JsonDecodeException> getCauses() {
            return this.errors;
        }

        @Override
        public String getMessage() {
            return OneOf.getMessage(this);
        }

        @Override
        public synchronized JsonDecodeException getCause() {
            return (JsonDecodeException)super.getCause();
        }
    }

    public static final class Failure
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final Json value;

        private Failure(String reason, Json value) {
            super(reason);
            this.value = value;
        }

        private Failure(Throwable cause, Json value) {
            super(cause);
            this.value = value;
        }

        public Json value() {
            return this.value;
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }
    }
}

