/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonBoolean;
import dev.mccue.json.JsonDecodeException;
import dev.mccue.json.JsonNull;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonObject;
import dev.mccue.json.JsonString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

interface JsonDecoder<T> {
    public T decode(Json var1) throws JsonDecodeException;

    default public <R> JsonDecoder<R> map(Function<? super T, ? extends R> f) {
        return value -> f.apply((T)this.decode(value));
    }

    public static <T> JsonDecoder<T> of(JsonDecoder<? extends T> decoder) {
        return decoder::decode;
    }

    public static String string(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonString)) {
            throw JsonDecodeException.of("expected a string", json);
        }
        JsonString jsonString = (JsonString)json;
        return jsonString.toString();
    }

    public static boolean boolean_(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonBoolean)) {
            throw JsonDecodeException.of("expected a boolean", json);
        }
        JsonBoolean jsonBoolean = (JsonBoolean)json;
        return jsonBoolean.value();
    }

    public static int int_(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNumber)) {
            throw JsonDecodeException.of("expected a number", json);
        }
        JsonNumber jsonNumber = (JsonNumber)json;
        if (!jsonNumber.isIntegral()) {
            throw JsonDecodeException.of("expected a number with no decimal part", json);
        }
        try {
            return jsonNumber.intValueExact();
        }
        catch (ArithmeticException e) {
            throw JsonDecodeException.of("expected a number which could be converted to an int", json);
        }
    }

    public static long long_(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNumber)) {
            throw JsonDecodeException.of("expected a number", json);
        }
        JsonNumber jsonNumber = (JsonNumber)json;
        if (!jsonNumber.isIntegral()) {
            throw JsonDecodeException.of("expected a number with no decimal part", json);
        }
        try {
            return jsonNumber.longValueExact();
        }
        catch (ArithmeticException e) {
            throw JsonDecodeException.of("expected a number which could be converted to a long", json);
        }
    }

    public static float float_(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNumber)) {
            throw JsonDecodeException.of("expected a number", json);
        }
        JsonNumber jsonNumber = (JsonNumber)json;
        return jsonNumber.floatValue();
    }

    public static double double_(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNumber)) {
            throw JsonDecodeException.of("expected a number", json);
        }
        JsonNumber jsonNumber = (JsonNumber)json;
        return jsonNumber.doubleValue();
    }

    public static BigInteger bigInteger(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNumber)) {
            throw JsonDecodeException.of("expected a number", json);
        }
        JsonNumber jsonNumber = (JsonNumber)json;
        try {
            return jsonNumber.bigIntegerValueExact();
        }
        catch (ArithmeticException e) {
            throw JsonDecodeException.of("expected a number which could be converted to a bigInteger", json);
        }
    }

    public static BigDecimal bigDecimal(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNumber)) {
            throw JsonDecodeException.of("expected a number", json);
        }
        JsonNumber jsonNumber = (JsonNumber)json;
        return jsonNumber.bigDecimalValue();
    }

    public static <T> T null_(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonNull)) {
            throw JsonDecodeException.of("expected null", json);
        }
        return null;
    }

    public static <T> JsonDecoder<List<T>> array(JsonDecoder<? extends T> itemDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.array(json, itemDecoder);
    }

    public static JsonArray array(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonArray)) {
            throw JsonDecodeException.of("expected an array", json);
        }
        JsonArray jsonArray = (JsonArray)json;
        return jsonArray;
    }

    public static <T> List<T> array(Json json, JsonDecoder<? extends T> itemDecoder) throws JsonDecodeException {
        if (!(json instanceof JsonArray)) {
            throw JsonDecodeException.of("expected an array", json);
        }
        JsonArray jsonArray = (JsonArray)json;
        ArrayList<T> items = new ArrayList<T>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Json jsonItem = (Json)jsonArray.get(i);
            try {
                items.add(itemDecoder.decode(jsonItem));
                continue;
            }
            catch (JsonDecodeException e) {
                throw JsonDecodeException.atIndex(i, e);
            }
            catch (Exception e) {
                throw JsonDecodeException.atIndex(i, JsonDecodeException.of(e, jsonItem));
            }
        }
        return List.copyOf(items);
    }

    public static JsonObject object(Json json) throws JsonDecodeException {
        if (!(json instanceof JsonObject)) {
            throw JsonDecodeException.of("expected an object", json);
        }
        JsonObject jsonObject = (JsonObject)json;
        return jsonObject;
    }

    public static <T> JsonDecoder<Map<String, T>> object(JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.object(json, valueDecoder);
    }

    public static <T> Map<String, T> object(Json json, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        JsonObject jsonObject = JsonDecoder.object(json);
        HashMap m = new HashMap(jsonObject.size());
        jsonObject.forEach((key, value) -> {
            try {
                m.put(key, valueDecoder.decode((Json)value));
            }
            catch (JsonDecodeException e) {
                throw JsonDecodeException.atField(key, e);
            }
            catch (Exception e) {
                throw JsonDecodeException.atField(key, JsonDecodeException.of(e, value));
            }
        });
        return Collections.unmodifiableMap(m);
    }

    public static <T> JsonDecoder<T> field(String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.field(json, fieldName, valueDecoder);
    }

    public static <T> T field(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        JsonObject jsonObject = JsonDecoder.object(json);
        Json value = (Json)jsonObject.get(fieldName);
        if (value == null) {
            throw JsonDecodeException.atField(fieldName, JsonDecodeException.of("no value for field", json));
        }
        try {
            return valueDecoder.decode(value);
        }
        catch (JsonDecodeException e) {
            throw JsonDecodeException.atField(fieldName, e);
        }
        catch (Exception e) {
            throw JsonDecodeException.atField(fieldName, JsonDecodeException.of(e, value));
        }
    }

    public static <T> JsonDecoder<T> nullableField(String fieldName, JsonDecoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodeException {
        return json -> JsonDecoder.nullableField(json, fieldName, valueDecoder, defaultValue);
    }

    public static <T> T nullableField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodeException {
        JsonDecoder<Object> decoder = JsonDecoder.nullable(valueDecoder).map(o -> o.map((? super T i) -> i)).map(o -> o.orElse(defaultValue));
        return (T)JsonDecoder.field(json, fieldName, decoder);
    }

    public static <T> JsonDecoder<Optional<T>> nullableField(String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.nullableField(json, fieldName, valueDecoder);
    }

    public static <T> Optional<T> nullableField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return JsonDecoder.nullableField(json, fieldName, valueDecoder.map(Optional::of), Optional.empty());
    }

    public static <T> JsonDecoder<T> optionalField(String fieldName, JsonDecoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodeException {
        return json -> JsonDecoder.optionalField(json, fieldName, valueDecoder, defaultValue);
    }

    public static <T> T optionalField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodeException {
        JsonObject jsonObject = JsonDecoder.object(json);
        Json value = (Json)jsonObject.get(fieldName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return valueDecoder.decode(value);
        }
        catch (JsonDecodeException e) {
            throw JsonDecodeException.atField(fieldName, e);
        }
        catch (Exception e) {
            throw JsonDecodeException.atField(fieldName, JsonDecodeException.of(e, value));
        }
    }

    public static <T> JsonDecoder<Optional<T>> optionalField(String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.optionalField(json, fieldName, valueDecoder);
    }

    public static <T> Optional<T> optionalField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return JsonDecoder.optionalField(json, fieldName, valueDecoder.map(Optional::of), Optional.empty());
    }

    public static <T> JsonDecoder<Optional<T>> optionalNullableField(String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.optionalNullableField(json, fieldName, valueDecoder);
    }

    public static <T> Optional<T> optionalNullableField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return JsonDecoder.optionalField(json, fieldName, JsonDecoder.nullable(valueDecoder), Optional.empty());
    }

    public static <T> JsonDecoder<T> optionalNullableField(String fieldName, JsonDecoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodeException {
        return json -> JsonDecoder.optionalNullableField(json, fieldName, valueDecoder, defaultValue);
    }

    public static <T> T optionalNullableField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder, T defaultValue) throws JsonDecodeException {
        JsonDecoder<Object> decoder = JsonDecoder.nullable(valueDecoder).map(opt -> opt.orElse(null)).map(value -> value == null ? defaultValue : value);
        return (T)JsonDecoder.optionalField(json, fieldName, decoder, defaultValue);
    }

    public static <T> JsonDecoder<T> optionalNullableField(String fieldName, JsonDecoder<? extends T> valueDecoder, T whenFieldMissing, T whenFieldNull) throws JsonDecodeException {
        return json -> JsonDecoder.optionalNullableField(json, fieldName, valueDecoder, whenFieldMissing, whenFieldNull);
    }

    public static <T> T optionalNullableField(Json json, String fieldName, JsonDecoder<? extends T> valueDecoder, T whenFieldMissing, T whenFieldNull) throws JsonDecodeException {
        JsonDecoder<Object> decoder = JsonDecoder.nullable(valueDecoder).map(opt -> opt.orElse(null)).map(value -> value == null ? whenFieldNull : value);
        return (T)JsonDecoder.optionalField(json, fieldName, decoder, whenFieldMissing);
    }

    public static <T> JsonDecoder<T> index(int index, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        return json -> JsonDecoder.index(json, index, valueDecoder);
    }

    public static <T> T index(Json json, int index, JsonDecoder<? extends T> valueDecoder) throws JsonDecodeException {
        JsonArray jsonArray = JsonDecoder.array(json);
        if (index >= jsonArray.size()) {
            throw JsonDecodeException.atIndex(index, JsonDecodeException.of("expected array index to be in bounds", json));
        }
        try {
            return valueDecoder.decode((Json)jsonArray.get(index));
        }
        catch (JsonDecodeException e) {
            throw JsonDecodeException.atIndex(index, e);
        }
        catch (Exception e) {
            throw JsonDecodeException.atIndex(index, JsonDecodeException.of(e, (Json)jsonArray.get(index)));
        }
    }

    public static <T> JsonDecoder<Optional<T>> nullable(JsonDecoder<? extends T> decoder) {
        return json -> JsonDecoder.oneOf(json, decoder.map(Optional::of), JsonDecoder.of(JsonDecoder::null_).map(__ -> Optional.empty()));
    }

    public static <T> JsonDecoder<T> nullable(JsonDecoder<? extends T> decoder, T defaultValue) {
        return json -> JsonDecoder.oneOf(json, decoder, (Json __) -> defaultValue);
    }

    public static <T> JsonDecoder<T> oneOf(JsonDecoder<? extends T> decoderA, JsonDecoder<? extends T> decoderB) throws JsonDecodeException {
        return json -> JsonDecoder.oneOf(json, decoderA, decoderB);
    }

    public static <T> T oneOf(Json json, JsonDecoder<? extends T> decoderA, JsonDecoder<? extends T> decoderB) throws JsonDecodeException {
        try {
            return decoderA.decode(json);
        }
        catch (JsonDecodeException e1) {
            try {
                return decoderB.decode(json);
            }
            catch (JsonDecodeException e2) {
                JsonDecodeException.OneOf oneOf;
                ArrayList<JsonDecodeException> errors = new ArrayList<JsonDecodeException>();
                if (e1 instanceof JsonDecodeException.OneOf) {
                    oneOf = (JsonDecodeException.OneOf)e1;
                    errors.addAll(oneOf.getCauses());
                } else {
                    errors.add(e1);
                }
                if (e2 instanceof JsonDecodeException.OneOf) {
                    oneOf = (JsonDecodeException.OneOf)e2;
                    errors.addAll(oneOf.getCauses());
                } else {
                    errors.add(e2);
                }
                throw JsonDecodeException.oneOf(Collections.unmodifiableList(errors));
            }
        }
    }

    @SafeVarargs
    public static <T> JsonDecoder<T> oneOf(JsonDecoder<? extends T> decoderA, JsonDecoder<? extends T> ... decoders) throws JsonDecodeException {
        return json -> JsonDecoder.oneOf(json, decoderA, decoders);
    }

    @SafeVarargs
    public static <T> T oneOf(Json json, JsonDecoder<? extends T> decoderA, JsonDecoder<? extends T> ... decoders) throws JsonDecodeException {
        try {
            return decoderA.decode(json);
        }
        catch (JsonDecodeException e1) {
            ArrayList<JsonDecodeException> errors = new ArrayList<JsonDecodeException>();
            if (e1 instanceof JsonDecodeException.OneOf) {
                JsonDecodeException.OneOf oneOf = (JsonDecodeException.OneOf)e1;
                errors.addAll(oneOf.getCauses());
            } else {
                errors.add(e1);
            }
            for (JsonDecoder<T> jsonDecoder : decoders) {
                try {
                    return jsonDecoder.decode(json);
                }
                catch (JsonDecodeException e2) {
                    if (e2 instanceof JsonDecodeException.OneOf) {
                        JsonDecodeException.OneOf oneOf = (JsonDecodeException.OneOf)e2;
                        errors.addAll(oneOf.getCauses());
                        continue;
                    }
                    errors.add(e2);
                }
            }
            throw JsonDecodeException.oneOf(Collections.unmodifiableList(errors));
        }
    }
}

