/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.internal.BigDecimalImpl;
import dev.mccue.json.internal.BigIntegerImpl;
import dev.mccue.json.internal.DoubleImpl;
import dev.mccue.json.internal.LongImpl;
import dev.mccue.json.stream.JsonGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class JsonNumber
extends Number
implements Json {
    private static final long serialVersionUID = 1L;

    protected JsonNumber() {
    }

    public abstract BigDecimal bigDecimalValue();

    public abstract BigInteger bigIntegerValue();

    public abstract int intValueExact();

    public abstract long longValueExact();

    public abstract BigInteger bigIntegerValueExact();

    public abstract boolean isIntegral();

    public static JsonNumber of(BigDecimal value) {
        return new BigDecimalImpl(value);
    }

    public static JsonNumber of(double value) {
        return new DoubleImpl(value);
    }

    public static JsonNumber of(long value) {
        return new LongImpl(value);
    }

    public static JsonNumber of(float value) {
        return new DoubleImpl(value);
    }

    public static JsonNumber of(int value) {
        return new LongImpl(value);
    }

    public static JsonNumber of(BigInteger value) {
        return new BigIntegerImpl(value);
    }

    @Override
    public void write(JsonGenerator generator) {
        generator.writeNumber(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JsonNumber)) return false;
        JsonNumber otherNumber = (JsonNumber)obj;
        if (!this.bigDecimalValue().equals(otherNumber.bigDecimalValue())) return false;
        return true;
    }

    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }
}

