/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.internal.ObjectBuilder;
import dev.mccue.json.internal.ObjectImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface JsonObject
extends Json,
Map<String, Json> {
    public static JsonObject of(Map<String, ? extends JsonEncodable> value) {
        return new ObjectImpl(value.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> {
            Objects.requireNonNull((String)entry.getKey(), "Json.Object cannot have null keys");
            return (String)entry.getKey();
        }, entry -> Json.of((JsonEncodable)entry.getValue()))));
    }

    public static Builder builder() {
        return new ObjectBuilder();
    }

    public static Builder builder(int initialCapacity) {
        return new ObjectBuilder(initialCapacity);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends JsonEncodable {
        public Builder put(String var1, Json var2);

        default public Builder put(String key, String value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, BigDecimal value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, double value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, long value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, float value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, int value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Double value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Long value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Float value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Integer value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, BigInteger value) {
            return this.put(key, Json.of(value));
        }

        default public Builder putNull(String key) {
            return this.put(key, Json.ofNull());
        }

        default public Builder putTrue(String key) {
            return this.put(key, Json.ofTrue());
        }

        default public Builder putFalse(String key) {
            return this.put(key, Json.ofFalse());
        }

        default public Builder put(String key, boolean value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Boolean value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Collection<? extends JsonEncodable> value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Map<String, ? extends JsonEncodable> value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, JsonEncodable value) {
            return this.put(key, value.toJson());
        }

        default public Builder put(String key, JsonObject value) {
            return this.put(key, (JsonEncodable)value);
        }

        default public Builder put(String key, JsonArray value) {
            return this.put(key, (JsonEncodable)value);
        }

        public Builder putAll(Map<String, ? extends JsonEncodable> var1);

        public JsonObject build();

        @Override
        default public Json toJson() {
            return this.build();
        }
    }
}

