/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.internal.ArrayImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record ArrayBuilderImpl(ArrayList<Json> values) implements JsonArray.Builder
{
    public ArrayBuilderImpl() {
        this(new ArrayList<Json>());
    }

    public ArrayBuilderImpl(int initialCapacity) {
        this(new ArrayList<Json>(initialCapacity));
    }

    @Override
    public JsonArray.Builder add(Json value) {
        this.values.add(value == null ? Json.ofNull() : value);
        return this;
    }

    @Override
    public JsonArray.Builder addAll(Collection<? extends JsonEncodable> value) {
        Objects.requireNonNull(value);
        value.forEach(v -> this.values.add(v == null ? Json.ofNull() : v.toJson()));
        return this;
    }

    @Override
    public JsonArray build() {
        return new ArrayImpl(List.copyOf(this.values));
    }

    JsonArray buildInternal() {
        return new ArrayImpl(Collections.unmodifiableList(this.values));
    }
}

