/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.serialization.JsonSerializationProxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class BigDecimalImpl
extends JsonNumber {
    private static final long serialVersionUID = 1L;
    private final BigDecimal bigDecimalValue;

    public BigDecimalImpl(BigDecimal bigDecimalValue) {
        this.bigDecimalValue = Objects.requireNonNull(bigDecimalValue, "bigDecimalValue must not be null.");
    }

    @Override
    public int intValue() {
        return this.bigDecimalValue.intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimalValue.longValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimalValue.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimalValue.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.bigDecimalValue;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimalValue.toBigInteger();
    }

    @Override
    public int intValueExact() {
        return this.bigDecimalValue.intValueExact();
    }

    @Override
    public long longValueExact() {
        return this.bigDecimalValue.longValueExact();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.bigDecimalValue.toBigIntegerExact();
    }

    @Override
    public boolean isIntegral() {
        return this.bigDecimalValue.scale() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof BigDecimalImpl)) return false;
        BigDecimalImpl otherBigDecimal = (BigDecimalImpl)o;
        if (!this.bigDecimalValue.equals(otherBigDecimal.bigDecimalValue)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue.hashCode();
    }

    public String toString() {
        return this.bigDecimalValue.toString();
    }

    private Object writeReplace() {
        return new JsonSerializationProxy(Json.writeString(this));
    }

    private Object readResolve() {
        throw new IllegalStateException();
    }
}

