/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.serialization.JsonSerializationProxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class BigIntegerImpl
extends JsonNumber {
    private static final long serialVersionUID = 1L;
    private final BigInteger bigIntegerValue;

    public BigIntegerImpl(BigInteger bigIntegerValue) {
        this.bigIntegerValue = Objects.requireNonNull(bigIntegerValue, "value must not be null");
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.bigIntegerValue);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigIntegerValue;
    }

    @Override
    public int intValueExact() {
        return this.bigIntegerValue().intValueExact();
    }

    @Override
    public long longValueExact() {
        return this.bigIntegerValue.longValueExact();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.bigIntegerValue;
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public int intValue() {
        return this.bigIntegerValue.intValue();
    }

    @Override
    public long longValue() {
        return this.bigIntegerValue.longValue();
    }

    @Override
    public float floatValue() {
        return this.bigIntegerValue.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigIntegerValue.doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof BigIntegerImpl)) return false;
        BigIntegerImpl otherBigInteger = (BigIntegerImpl)o;
        if (!this.bigIntegerValue.equals(otherBigInteger.bigIntegerValue)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.bigIntegerValue.hashCode();
    }

    public String toString() {
        return this.bigIntegerValue.toString();
    }

    private Object writeReplace() {
        return new JsonSerializationProxy(Json.writeString(this));
    }

    private Object readResolve() {
        throw new IllegalStateException();
    }
}

