/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.serialization.JsonSerializationProxy;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DoubleImpl
extends JsonNumber {
    private static final long serialVersionUID = 1L;
    private final double doubleValue;

    public DoubleImpl(double doubleValue) {
        if (Double.isInfinite(doubleValue)) {
            throw new IllegalArgumentException("JSON cannot encode an infinite double");
        }
        if (Double.isNaN(doubleValue)) {
            throw new IllegalArgumentException("JSON cannot encode a NaN double");
        }
        this.doubleValue = doubleValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.doubleValue);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf((long)this.doubleValue);
    }

    @Override
    public int intValueExact() {
        if ((double)((int)this.doubleValue) == this.doubleValue) {
            return (int)this.doubleValue;
        }
        throw new ArithmeticException(this.doubleValue + " cannot fit into an int");
    }

    @Override
    public long longValueExact() {
        if ((double)((long)this.doubleValue) == this.doubleValue) {
            return (int)this.doubleValue;
        }
        throw new ArithmeticException(this.doubleValue + " cannot fit into an int");
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return BigDecimal.valueOf(this.doubleValue).toBigIntegerExact();
    }

    @Override
    public boolean isIntegral() {
        return (double)((int)this.doubleValue) == this.doubleValue;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue;
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue;
    }

    @Override
    public double doubleValue() {
        return this.doubleValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DoubleImpl)) return false;
        DoubleImpl otherDouble = (DoubleImpl)o;
        if (this.doubleValue != otherDouble.doubleValue) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.doubleValue);
    }

    public String toString() {
        return Double.toString(this.doubleValue);
    }

    private Object writeReplace() {
        return new JsonSerializationProxy(Json.writeString(this));
    }

    private Object readResolve() {
        throw new IllegalStateException();
    }
}

