/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonObject;
import dev.mccue.json.JsonString;
import dev.mccue.json.internal.ArrayBuilderImpl;
import dev.mccue.json.internal.ObjectBuilder;
import java.util.function.Consumer;

final class Handlers {
    private Handlers() {
    }

    static final class BaseTreeValueHandler
    implements Json.ValueHandler {
        Json result = null;
        final TreeValueHandler delegate = new TreeValueHandler(value -> {
            this.result = value;
        });

        BaseTreeValueHandler() {
        }

        @Override
        public Json.ObjectHandler onObjectStart() {
            return this.delegate.onObjectStart();
        }

        @Override
        public Json.ArrayHandler onArrayStart() {
            return this.delegate.onArrayStart();
        }

        @Override
        public void onNumber(JsonNumber number) {
            this.delegate.onNumber(number);
        }

        @Override
        public void onString(String value) {
            this.delegate.onString(value);
        }

        @Override
        public void onNull() {
            this.delegate.onNull();
        }

        @Override
        public void onTrue() {
            this.delegate.onTrue();
        }

        @Override
        public void onFalse() {
            this.delegate.onFalse();
        }
    }

    record TreeValueHandler(Consumer<Json> onValue) implements Json.ValueHandler
    {
        @Override
        public Json.ObjectHandler onObjectStart() {
            return new TreeObjectHandler(this.onValue::accept);
        }

        @Override
        public Json.ArrayHandler onArrayStart() {
            return new TreeArrayHandler(this.onValue::accept);
        }

        @Override
        public void onNumber(JsonNumber number) {
            this.onValue.accept(number);
        }

        @Override
        public void onString(String value) {
            this.onValue.accept(JsonString.of(value));
        }

        @Override
        public void onNull() {
            this.onValue.accept(Json.ofNull());
        }

        @Override
        public void onTrue() {
            this.onValue.accept(Json.ofTrue());
        }

        @Override
        public void onFalse() {
            this.onValue.accept(Json.ofFalse());
        }
    }

    record TreeArrayHandler(JsonArray.Builder builder, Consumer<JsonArray> onArray) implements Json.ArrayHandler
    {
        TreeArrayHandler(Consumer<JsonArray> onArray) {
            this(Json.arrayBuilder(), onArray);
        }

        @Override
        public void onArrayEnd() {
            this.onArray.accept(((ArrayBuilderImpl)this.builder).buildInternal());
        }

        @Override
        public Json.ObjectHandler onObjectStart() {
            return new TreeObjectHandler(this.builder::add);
        }

        @Override
        public Json.ArrayHandler onArrayStart() {
            return new TreeArrayHandler(this.builder::add);
        }

        @Override
        public void onNumber(JsonNumber number) {
            this.builder.add(number);
        }

        @Override
        public void onString(String value) {
            this.builder.add(JsonString.of(value));
        }

        @Override
        public void onNull() {
            this.builder.add(Json.ofNull());
        }

        @Override
        public void onTrue() {
            this.builder.add(Json.ofTrue());
        }

        @Override
        public void onFalse() {
            this.builder.add(Json.ofFalse());
        }
    }

    record TreeObjectHandler(JsonObject.Builder builder, Consumer<JsonObject> onObject) implements Json.ObjectHandler
    {
        TreeObjectHandler(Consumer<JsonObject> onObject) {
            this(Json.objectBuilder(), onObject);
        }

        @Override
        public Json.ValueHandler onField(String fieldName) {
            return new TreeValueHandler(value -> this.builder.put(fieldName, (Json)value));
        }

        @Override
        public void objectEnd() {
            this.onObject.accept(((ObjectBuilder)this.builder).buildInternal());
        }
    }
}

