/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonReadException;
import dev.mccue.json.internal.BigDecimalImpl;
import dev.mccue.json.internal.DoubleImpl;
import dev.mccue.json.internal.Handlers;
import dev.mccue.json.stream.JsonEvent;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonReaderMethods {
    public static final int MINIMUM_PUSHBACK_BUFFER_SIZE = 64;

    private JsonReaderMethods() {
    }

    private static char readHexChar(PushbackReader stream) throws IOException {
        int a = stream.read();
        int b = stream.read();
        int c = stream.read();
        int d = stream.read();
        if (a < 0 || b < 0 || c < 0 || d < 0) {
            throw JsonReadException.unexpectedEOFInsideUnicodeCharacterEscape();
        }
        String s = String.valueOf(new char[]{(char)a, (char)b, (char)c, (char)d});
        return (char)Integer.parseInt(s, 16);
    }

    private static char readEscapedChar(PushbackReader stream) throws IOException {
        int c = stream.read();
        if (c < 0) {
            throw JsonReadException.unexpectedEOFInsideEscapedChar();
        }
        return switch ((char)c) {
            case '\"', '/', '\\' -> (char)c;
            case 'b' -> 8;
            case 'f' -> 12;
            case 'n' -> 10;
            case 'r' -> 13;
            case 't' -> 9;
            case 'u' -> JsonReaderMethods.readHexChar(stream);
            default -> throw JsonReadException.invalidEscapeCharacter((char)c);
        };
    }

    private static String slowReadString(PushbackReader stream, String alreadyRead) throws IOException {
        StringBuilder buffer = new StringBuilder(alreadyRead);
        block4: while (true) {
            int c;
            if ((c = stream.read()) < 0) {
                throw JsonReadException.unexpectedEOFInsideString();
            }
            switch ((char)c) {
                case '\"': {
                    return buffer.toString();
                }
                case '\\': {
                    buffer.append(JsonReaderMethods.readEscapedChar(stream));
                    continue block4;
                }
            }
            buffer.append((char)c);
        }
    }

    private static String readQuotedString(PushbackReader stream) throws IOException {
        char[] buffer = new char[64];
        int read = stream.read(buffer, 0, 64);
        int endIndex = read - 1;
        if (read < 0) {
            throw JsonReadException.unexpectedEOFInsideString();
        }
        int i = 0;
        while (true) {
            char c = buffer[i];
            switch (c) {
                case '\"': {
                    int off = i + 1;
                    int len = read - off;
                    stream.unread(buffer, off, len);
                    return new String(buffer, 0, i);
                }
                case '\\': {
                    int off = i;
                    int len = read - off;
                    stream.unread(buffer, off, len);
                    return JsonReaderMethods.slowReadString(stream, new String(buffer, 0, i));
                }
            }
            if (i == endIndex) {
                stream.unread(c);
                return JsonReaderMethods.slowReadString(stream, new String(buffer, 0, i));
            }
            ++i;
        }
    }

    private static JsonNumber readInteger(String string) {
        if (string.length() < 18) {
            return JsonNumber.of(Long.parseLong(string));
        }
        try {
            return JsonNumber.of(Long.parseLong(string));
        }
        catch (NumberFormatException __) {
            return JsonNumber.of(new BigInteger(string));
        }
    }

    private static JsonNumber readDecimal(String string, boolean bigDecimal) {
        if (bigDecimal) {
            return new BigDecimalImpl(new BigDecimal(string));
        }
        return new DoubleImpl(Double.parseDouble(string));
    }

    private static JsonNumber readNumber(PushbackReader stream, boolean bigDecimal) throws IOException {
        boolean isDecimal;
        StringBuilder buffer = new StringBuilder();
        static enum Stage {
            MINUS,
            INT_ZERO,
            INT_DIGIT,
            FRAC_POINT,
            FRAC_FIRST,
            FRAC_DIGIT,
            EXP_SYMBOL,
            EXP_FIRST,
            EXP_DIGIT;

        }
        Stage stage = Stage.MINUS;
        block50: while (true) {
            int c = stream.read();
            switch (stage) {
                case MINUS: {
                    switch (c) {
                        case 45: {
                            buffer.append((char)c);
                            stage = Stage.INT_ZERO;
                            continue block50;
                        }
                        case 48: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_POINT;
                            continue block50;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.INT_DIGIT;
                            continue block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case INT_ZERO: {
                    switch (c) {
                        case 48: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_POINT;
                            continue block50;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.INT_DIGIT;
                            continue block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case INT_DIGIT: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            continue block50;
                        }
                        case 46: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_FIRST;
                            continue block50;
                        }
                        case 69: 
                        case 101: {
                            buffer.append((char)c);
                            stage = Stage.EXP_SYMBOL;
                            continue block50;
                        }
                        case -1: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = false;
                            break block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case FRAC_POINT: {
                    switch (c) {
                        case 46: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_FIRST;
                            continue block50;
                        }
                        case 69: 
                        case 101: {
                            buffer.append((char)c);
                            stage = Stage.EXP_SYMBOL;
                            continue block50;
                        }
                        case -1: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = false;
                            break block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case FRAC_FIRST: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_DIGIT;
                            continue block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case FRAC_DIGIT: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            continue block50;
                        }
                        case 69: 
                        case 101: {
                            buffer.append((char)c);
                            stage = Stage.EXP_SYMBOL;
                            continue block50;
                        }
                        case -1: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = true;
                            break block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case EXP_SYMBOL: {
                    switch (c) {
                        case 43: 
                        case 45: {
                            buffer.append((char)c);
                            stage = Stage.EXP_FIRST;
                            continue block50;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.EXP_DIGIT;
                            continue block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case EXP_FIRST: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.EXP_DIGIT;
                            continue block50;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case EXP_DIGIT: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            break;
                        }
                        case -1: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = true;
                            break block50;
                        }
                        default: {
                            throw JsonReadException.invalidNumberLiteral();
                        }
                    }
                }
                default: {
                    continue block50;
                }
            }
            break;
        }
        if (isDecimal) {
            return JsonReaderMethods.readDecimal(buffer.toString(), bigDecimal);
        }
        return JsonReaderMethods.readInteger(buffer.toString());
    }

    private static int nextToken(PushbackReader stream) throws IOException {
        int c = stream.read();
        block4: while (true) {
            if (32 < c) {
                return c;
            }
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    c = stream.read();
                    continue block4;
                }
                case -1: {
                    return -1;
                }
            }
            break;
        }
        throw JsonReadException.invalidToken();
    }

    private static String readKey(PushbackReader stream) throws IOException {
        int c = JsonReaderMethods.nextToken(stream);
        if (c == 34) {
            String key = JsonReaderMethods.readQuotedString(stream);
            if (58 == JsonReaderMethods.nextToken(stream)) {
                return key;
            }
            throw JsonReadException.missingColonInObject();
        }
        if (c == 125) {
            return null;
        }
        throw JsonReadException.nonStringKeyInObject((char)c);
    }

    private static boolean readUll(PushbackReader stream) throws IOException {
        return stream.read() == 117 && stream.read() == 108 && stream.read() == 108;
    }

    private static boolean readRue(PushbackReader stream) throws IOException {
        return stream.read() == 114 && stream.read() == 117 && stream.read() == 101;
    }

    private static boolean readAlse(PushbackReader stream) throws IOException {
        return stream.read() == 97 && stream.read() == 108 && stream.read() == 115 && stream.read() == 101;
    }

    private static void readArrayHelperStream(PushbackReader stream, Json.StreamReadOptions options, Json.ArrayHandler arrayHandler) throws IOException {
        block4: while (true) {
            JsonReaderMethods.readStream(stream, true, options, arrayHandler);
            switch ((char)JsonReaderMethods.nextToken(stream)) {
                case ']': {
                    arrayHandler.onArrayEnd();
                    return;
                }
                case ',': {
                    continue block4;
                }
            }
            break;
        }
        throw JsonReadException.invalidArray();
    }

    private static void readArrayStream(PushbackReader stream, Json.StreamReadOptions options, Json.ValueHandler valueHandler) throws IOException {
        Json.ArrayHandler arrayHandler = valueHandler.onArrayStart();
        int c = JsonReaderMethods.nextToken(stream);
        switch (c) {
            case 93: {
                arrayHandler.onArrayEnd();
                break;
            }
            case 44: {
                throw JsonReadException.invalidArray();
            }
            default: {
                stream.unread(c);
                JsonReaderMethods.readArrayHelperStream(stream, options, arrayHandler);
            }
        }
    }

    private static void readObjectStream(PushbackReader stream, Json.StreamReadOptions options, Json.ValueHandler valueHandler) throws IOException {
        String key;
        boolean readSomeEntry = false;
        Json.ObjectHandler objectHandler = valueHandler.onObjectStart();
        block4: while ((key = JsonReaderMethods.readKey(stream)) != null) {
            readSomeEntry = true;
            Json.ValueHandler fieldHandler = objectHandler.onField(key);
            JsonReaderMethods.readStream(stream, true, options, fieldHandler);
            switch (JsonReaderMethods.nextToken(stream)) {
                case 44: {
                    continue block4;
                }
                case 125: {
                    objectHandler.objectEnd();
                    return;
                }
            }
            throw JsonReadException.missingEntryInObject();
        }
        if (readSomeEntry) {
            throw JsonReadException.emptyEntryInObject();
        }
        objectHandler.objectEnd();
    }

    public static void readStream(PushbackReader stream, boolean throwIfEofEncountered, Json.StreamReadOptions options, Json.ValueHandler valueHandler) throws IOException {
        int c = JsonReaderMethods.nextToken(stream);
        switch (c) {
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                stream.unread(c);
                valueHandler.onNumber(JsonReaderMethods.readNumber(stream, options.useBigDecimals()));
                break;
            }
            case 34: {
                valueHandler.onString(JsonReaderMethods.readQuotedString(stream));
                break;
            }
            case 110: {
                if (JsonReaderMethods.readUll(stream)) {
                    valueHandler.onNull();
                    break;
                }
                throw JsonReadException.expectedNull();
            }
            case 116: {
                if (JsonReaderMethods.readRue(stream)) {
                    valueHandler.onTrue();
                    break;
                }
                throw JsonReadException.expectedTrue();
            }
            case 102: {
                if (JsonReaderMethods.readAlse(stream)) {
                    valueHandler.onFalse();
                    break;
                }
                throw JsonReadException.expectedFalse();
            }
            case 123: {
                JsonReaderMethods.readObjectStream(stream, options, valueHandler);
                break;
            }
            case 91: {
                JsonReaderMethods.readArrayStream(stream, options, valueHandler);
                break;
            }
            default: {
                if (c < 0) {
                    if (!throwIfEofEncountered) break;
                    throw JsonReadException.unexpectedEOF();
                }
                throw JsonReadException.unexpectedCharacter((char)c);
            }
        }
    }

    public static Json read(PushbackReader stream, Json.ReadOptions options) throws IOException {
        Handlers.BaseTreeValueHandler handler = new Handlers.BaseTreeValueHandler();
        JsonReaderMethods.readStream(stream, false, new Json.StreamReadOptions(options.useBigDecimals()), handler);
        if (handler.result == null && options.eofBehavior() == Json.EOFBehavior.THROW_EXCEPTION) {
            throw JsonReadException.unexpectedEOF();
        }
        return handler.result;
    }

    static final class EventIterator
    implements Iterator<JsonEvent> {
        final PushbackReader stream;
        Json.StreamReadOptions options;
        State state;
        JsonEvent next;

        EventIterator(PushbackReader stream, Json.StreamReadOptions options) {
            this.stream = stream;
            this.options = options;
            this.state = new Root(false, new Terminated());
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.state instanceof Root) {
                    this.state.advance(this);
                }
                return this.next != null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public JsonEvent next() {
            try {
                if (this.state instanceof Root) {
                    this.state.advance(this);
                }
                if (this.state instanceof Terminated && this.next == null) {
                    throw new NoSuchElementException();
                }
                JsonEvent next = this.next;
                this.state.advance(this);
                return next;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public static void main(String[] args) throws IOException {
            EventIterator iter = new EventIterator(new PushbackReader(new StringReader("[1, 2, [], [\"a\", \"b\", true], 3]"), 64), new Json.StreamReadOptions());
            while (iter.hasNext()) {
                System.out.println(iter.next());
            }
        }

        record Root(boolean throwIfEofEncountered, State previous) implements State
        {
            Root() {
                this(false, new Terminated());
            }

            @Override
            public void advance(EventIterator self) throws IOException {
                int c = JsonReaderMethods.nextToken(self.stream);
                switch (c) {
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        self.stream.unread(c);
                        self.next = new JsonEvent.Number(JsonReaderMethods.readNumber(self.stream, self.options.useBigDecimals()));
                        self.state = this.previous;
                        break;
                    }
                    case 34: {
                        self.next = new JsonEvent.String(JsonReaderMethods.readQuotedString(self.stream));
                        self.state = this.previous;
                        break;
                    }
                    case 110: {
                        if (JsonReaderMethods.readUll(self.stream)) {
                            self.next = new JsonEvent.Null();
                            self.state = this.previous;
                            break;
                        }
                        throw JsonReadException.expectedNull();
                    }
                    case 116: {
                        if (JsonReaderMethods.readRue(self.stream)) {
                            self.next = new JsonEvent.True();
                            self.state = this.previous;
                            break;
                        }
                        throw JsonReadException.expectedTrue();
                    }
                    case 102: {
                        if (JsonReaderMethods.readAlse(self.stream)) {
                            self.next = new JsonEvent.False();
                            self.state = this.previous;
                            break;
                        }
                        throw JsonReadException.expectedFalse();
                    }
                    case 123: {
                        throw new IllegalStateException("unhandled");
                    }
                    case 91: {
                        self.next = new JsonEvent.ArrayStart();
                        self.state = new ReadArray(this.previous);
                        break;
                    }
                    default: {
                        if (c < 0) {
                            if (!this.throwIfEofEncountered) break;
                            throw JsonReadException.unexpectedEOF();
                        }
                        throw JsonReadException.unexpectedCharacter((char)c);
                    }
                }
            }
        }

        record Terminated() implements State
        {
            @Override
            public void advance(EventIterator self) throws IOException {
                self.next = null;
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static interface State {
            public void advance(EventIterator var1) throws IOException;
        }

        record ReadArray(State previous) implements State
        {
            @Override
            public void advance(EventIterator self) throws IOException {
                int c = JsonReaderMethods.nextToken(self.stream);
                switch (c) {
                    case 93: {
                        self.next = new JsonEvent.ArrayEnd();
                        self.state = this.previous;
                        break;
                    }
                    case 44: {
                        throw JsonReadException.invalidArray();
                    }
                    default: {
                        self.stream.unread(c);
                        self.state = new Root(true, new ReadArrayHelper(this.previous));
                        self.state.advance(self);
                    }
                }
            }
        }

        record ReadArrayHelper(State previous) implements State
        {
            @Override
            public void advance(EventIterator self) throws IOException {
                char c = (char)JsonReaderMethods.nextToken(self.stream);
                switch (c) {
                    case ']': {
                        self.next = new JsonEvent.ArrayEnd();
                        self.state = this.previous;
                        break;
                    }
                    case ',': {
                        self.state = new Root(true, this);
                        self.state.advance(self);
                        break;
                    }
                    default: {
                        System.out.println("" + c);
                        throw JsonReadException.invalidArray();
                    }
                }
            }
        }

        record ReadObject(boolean readSomeEntry, State previous) implements State
        {
            ReadObject(State previous) {
                this(false, previous);
            }

            @Override
            public void advance(EventIterator self) throws IOException {
                String key = JsonReaderMethods.readKey(self.stream);
                if (key != null) {
                    self.next = new JsonEvent.Field(key);
                } else {
                    if (this.readSomeEntry) {
                        throw JsonReadException.emptyEntryInObject();
                    }
                    self.state = this.previous;
                }
            }
        }

        record ReadObjectValue(State previous) implements State
        {
            @Override
            public void advance(EventIterator self) throws IOException {
            }
        }
    }
}

