/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.serialization.JsonSerializationProxy;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class LongImpl
extends JsonNumber {
    private static final long serialVersionUID = 1L;
    private final long longValue;

    public LongImpl(long longValue) {
        this.longValue = longValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue);
    }

    @Override
    public int intValueExact() {
        if (this.longValue <= Integer.MAX_VALUE && this.longValue >= Integer.MIN_VALUE) {
            return (int)this.longValue;
        }
        throw new ArithmeticException(this.longValue + " cannot fit into an int.");
    }

    @Override
    public long longValueExact() {
        return this.longValue;
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return BigInteger.valueOf(this.longValue);
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public int intValue() {
        return (int)this.longValue;
    }

    @Override
    public long longValue() {
        return this.longValue;
    }

    @Override
    public float floatValue() {
        return this.longValue;
    }

    @Override
    public double doubleValue() {
        return this.longValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LongImpl)) return false;
        LongImpl otherLong = (LongImpl)o;
        if (this.longValue != otherLong.longValue) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.longValue);
    }

    public String toString() {
        return Long.toString(this.longValue);
    }

    private Object writeReplace() {
        return new JsonSerializationProxy(Json.writeString(this));
    }

    private Object readResolve() {
        throw new IllegalStateException();
    }
}

