/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.JsonObject;
import dev.mccue.json.internal.ObjectImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public record ObjectBuilder(HashMap<String, Json> values) implements JsonObject.Builder
{
    public ObjectBuilder() {
        this(new HashMap<String, Json>());
    }

    public ObjectBuilder(int initialCapacity) {
        this(new HashMap<String, Json>(initialCapacity));
    }

    @Override
    public JsonObject.Builder put(String key, Json value) {
        this.values.put(key, value == null ? Json.ofNull() : value);
        return this;
    }

    @Override
    public JsonObject.Builder putAll(Map<String, ? extends JsonEncodable> values) {
        values.forEach((k, v) -> this.put((String)k, v == null ? Json.ofNull() : v.toJson()));
        return this;
    }

    @Override
    public JsonObject build() {
        return new ObjectImpl(Map.copyOf(this.values));
    }

    JsonObject buildInternal() {
        return new ObjectImpl(Collections.unmodifiableMap(this.values));
    }
}

