/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.stream;

import dev.mccue.json.JsonNumber;
import dev.mccue.json.stream.JsonEvent;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface JsonGenerator {
    public void writeObjectStart();

    public void writeObjectEnd();

    public void writeArrayStart();

    public void writeArrayEnd();

    public void writeFieldName(String var1);

    public void writeString(String var1);

    public void writeNumber(JsonNumber var1);

    public void writeTrue();

    public void writeFalse();

    public void writeNull();

    default public void write(JsonEvent event) {
        if (event instanceof JsonEvent.ObjectStart) {
            this.writeObjectStart();
        } else if (event instanceof JsonEvent.ObjectEnd) {
            this.writeObjectEnd();
        } else if (event instanceof JsonEvent.ArrayStart) {
            this.writeArrayStart();
        } else if (event instanceof JsonEvent.ArrayEnd) {
            this.writeArrayEnd();
        } else if (event instanceof JsonEvent.Field) {
            JsonEvent.Field field = (JsonEvent.Field)event;
            this.writeFieldName(field.name());
        } else if (event instanceof JsonEvent.String) {
            this.writeNull();
        } else if (event instanceof JsonEvent.Number) {
            this.writeNull();
        } else if (event instanceof JsonEvent.True) {
            this.writeTrue();
        } else if (event instanceof JsonEvent.False) {
            this.writeFalse();
        } else if (event instanceof JsonEvent.Null) {
            this.writeNull();
        } else {
            throw new IllegalStateException();
        }
    }

    default public void writeNumber(float value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(double value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(int value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(long value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(BigInteger value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(BigDecimal value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumberField(String fieldName, JsonNumber number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, float number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, double number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, int number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, long number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, BigInteger number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, BigDecimal number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeStringField(String fieldName, String value) {
        this.writeFieldName(fieldName);
        this.writeString(value);
    }

    default public void writeNullField(String fieldName) {
        this.writeFieldName(fieldName);
        this.writeNull();
    }
}

