/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonBoolean;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.JsonEncoder;
import dev.mccue.json.JsonNull;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonObject;
import dev.mccue.json.JsonReadException;
import dev.mccue.json.JsonReadOptions;
import dev.mccue.json.JsonReader;
import dev.mccue.json.JsonString;
import dev.mccue.json.JsonWriteOptions;
import dev.mccue.json.internal.ArrayBuilderImpl;
import dev.mccue.json.internal.ArrayImpl;
import dev.mccue.json.internal.JsonReaderMethods;
import dev.mccue.json.internal.JsonWriter;
import dev.mccue.json.internal.ObjectBuilder;
import dev.mccue.json.internal.ObjectImpl;
import dev.mccue.json.internal.StringImpl;
import dev.mccue.json.stream.JsonStreamReadOptions;
import dev.mccue.json.stream.JsonValueHandler;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public sealed interface Json
extends Serializable,
JsonEncodable
permits JsonBoolean, JsonNull, JsonString, JsonNumber, JsonArray, JsonObject {
    public static Json of(@Nullable JsonEncodable value) {
        if (value == null) {
            return JsonNull.instance();
        }
        Json asJson = value.toJson();
        if (asJson == null) {
            return JsonNull.instance();
        }
        return asJson;
    }

    public static Json of(@Nullable BigDecimal value) {
        return value == null ? JsonNull.instance() : JsonNumber.of(value);
    }

    public static Json of(double value) {
        return JsonNumber.of(value);
    }

    public static Json of(long value) {
        return JsonNumber.of(value);
    }

    public static Json of(float value) {
        return JsonNumber.of(value);
    }

    public static Json of(int value) {
        return JsonNumber.of(value);
    }

    public static Json of(@Nullable Double value) {
        return value == null ? JsonNull.instance() : Json.of((double)value);
    }

    public static Json of(@Nullable Long value) {
        return value == null ? JsonNull.instance() : Json.of((long)value);
    }

    public static Json of(@Nullable Float value) {
        return value == null ? JsonNull.instance() : Json.of(value.floatValue());
    }

    public static Json of(@Nullable Integer value) {
        return value == null ? JsonNull.instance() : Json.of((int)value);
    }

    public static Json of(@Nullable BigInteger value) {
        return value == null ? JsonNull.instance() : JsonNumber.of(value);
    }

    public static Json of(@Nullable String value) {
        return value == null ? JsonNull.instance() : new StringImpl(value);
    }

    public static Json ofNull() {
        return JsonNull.instance();
    }

    public static Json ofTrue() {
        return JsonBoolean.of(true);
    }

    public static Json ofFalse() {
        return JsonBoolean.of(false);
    }

    public static Json of(boolean value) {
        return JsonBoolean.of(value);
    }

    public static Json of(@Nullable Boolean value) {
        return value == null ? JsonNull.instance() : JsonBoolean.of((boolean)value);
    }

    public static Json of(@Nullable Collection<? extends @Nullable JsonEncodable> value) {
        return value == null ? JsonNull.instance() : new ArrayImpl(value.stream().map(json -> json == null ? JsonNull.instance() : json.toJson()).toList());
    }

    public static <T> Json of(@Nullable Collection<? extends T> value, JsonEncoder<T> encoder) {
        return value == null ? JsonNull.instance() : new ArrayImpl(value.stream().map(v -> {
            Json result = encoder.encode(v);
            if (result == null) {
                return JsonNull.instance();
            }
            return result;
        }).toList());
    }

    public static Json of(@Nullable Map<String, ? extends @Nullable JsonEncodable> value) {
        return value == null ? JsonNull.instance() : new ObjectImpl(value.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> entry.getValue() == null ? JsonNull.instance() : ((JsonEncodable)entry.getValue()).toJson())));
    }

    public static <T> Json of(@Nullable Map<String, ? extends @Nullable T> value, JsonEncoder<T> encoder) {
        return value == null ? JsonNull.instance() : new ObjectImpl(value.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
            Json result = encoder.encode(entry.getValue());
            if (result == null) {
                return JsonNull.instance();
            }
            return result;
        })));
    }

    public static JsonObject.Builder objectBuilder() {
        return JsonObject.builder();
    }

    public static JsonObject.Builder objectBuilder(Map<String, ? extends JsonEncodable> value) {
        if (value instanceof JsonObject) {
            JsonObject o = (JsonObject)value;
            return new ObjectBuilder(new LinkedHashMap<String, Json>(o));
        }
        LinkedHashMap<String, Json> objectEntries = new LinkedHashMap<String, Json>();
        for (Map.Entry<String, ? extends JsonEncodable> entry : value.entrySet()) {
            objectEntries.put(entry.getKey(), Json.of(entry.getValue()));
        }
        return new ObjectBuilder(objectEntries);
    }

    public static JsonArray.Builder arrayBuilder() {
        return JsonArray.builder();
    }

    public static JsonArray.Builder arrayBuilder(Collection<? extends @Nullable JsonEncodable> elements) {
        if (elements instanceof JsonArray) {
            JsonArray o = (JsonArray)elements;
            return new ArrayBuilderImpl(new ArrayList<Json>(o));
        }
        return new ArrayBuilderImpl(new ArrayList<Json>(elements.stream().map(Json::of).toList()));
    }

    public static JsonArray emptyArray() {
        return ArrayImpl.EMPTY;
    }

    public static JsonObject emptyObject() {
        return ObjectImpl.EMPTY;
    }

    public static Collector<JsonEncodable, ?, JsonArray> arrayCollector() {
        return JsonArray.collector();
    }

    public static <T> Collector<T, ?, JsonObject> objectCollector(Function<? super T, String> keyMapper, Function<? super T, ? extends JsonEncodable> valueMapper) {
        return JsonObject.collector(keyMapper, valueMapper);
    }

    @Override
    default public Json toJson() {
        return this;
    }

    public static Json readString(CharSequence jsonText) throws JsonReadException {
        return Json.readString(jsonText, new JsonReadOptions());
    }

    public static Json readString(CharSequence jsonText, JsonReadOptions options) throws JsonReadException {
        try {
            return JsonReaderMethods.readFullyConsume(new PushbackReader(new StringReader(jsonText.toString())), options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Json read(CharSequence jsonText) throws JsonReadException {
        return Json.readString(jsonText);
    }

    public static Json read(CharSequence jsonText, JsonReadOptions options) throws JsonReadException {
        return Json.readString(jsonText, options);
    }

    public static Json read(Reader reader, JsonReadOptions options) throws IOException, JsonReadException {
        return JsonReaderMethods.readFullyConsume(new PushbackReader(reader), options);
    }

    public static Json read(Reader reader) throws IOException, JsonReadException {
        return Json.read(reader, new JsonReadOptions());
    }

    public static JsonReader reader(Reader reader, JsonReadOptions options) {
        PushbackReader pushbackReader = new PushbackReader(reader);
        return () -> {
            try {
                return JsonReaderMethods.read(pushbackReader, options);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static JsonReader reader(Reader reader) {
        return Json.reader(reader, new JsonReadOptions().withEOFBehavior(JsonReadOptions.EOFBehavior.RETURN_NULL));
    }

    public static void readStream(Reader reader, JsonValueHandler handler, JsonStreamReadOptions options) throws IOException, JsonReadException {
        JsonReaderMethods.readStream(new PushbackReader(reader), false, options, handler);
    }

    public static void readStream(Reader reader, JsonValueHandler handler) throws IOException, JsonReadException {
        JsonReaderMethods.readStream(new PushbackReader(reader), false, new JsonStreamReadOptions(), handler);
    }

    private static String writeString(Json json) {
        return Json.writeString(json, new JsonWriteOptions());
    }

    private static String writeString(Json json, JsonWriteOptions options) {
        StringWriter sw = new StringWriter();
        try {
            Json.write(json, (Writer)sw, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return sw.toString();
    }

    public static String writeString(@Nullable JsonEncodable jsonEncodable) {
        return Json.writeString(Json.of(jsonEncodable));
    }

    public static String writeString(@Nullable JsonEncodable jsonEncodable, JsonWriteOptions options) {
        return Json.writeString(Json.of(jsonEncodable), options);
    }

    public static String write(@Nullable JsonEncodable jsonEncodable) {
        return Json.writeString(jsonEncodable);
    }

    public static String write(@Nullable JsonEncodable jsonEncodable, JsonWriteOptions options) {
        return Json.writeString(jsonEncodable, options);
    }

    private static void write(Json json, Writer writer, JsonWriteOptions options) throws IOException {
        new JsonWriter().write(json, writer, options);
    }

    private static void write(Json json, Writer writer) throws IOException {
        new JsonWriter().write(json, writer, new JsonWriteOptions());
    }

    public static void write(@Nullable JsonEncodable jsonEncodable, Writer writer, JsonWriteOptions options) throws IOException {
        Json.write(Json.of(jsonEncodable), writer, options);
    }

    public static void write(@Nullable JsonEncodable jsonEncodable, Writer writer) throws IOException {
        Json.write(Json.of(jsonEncodable), writer);
    }
}

