/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.internal.ArrayBuilderImpl;
import dev.mccue.json.internal.ArrayImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collector;
import org.jspecify.annotations.Nullable;

public sealed interface JsonArray
extends Json,
List<Json>
permits ArrayImpl {
    public static JsonArray of(Json ... values) {
        return JsonArray.of(Arrays.asList(values));
    }

    public static JsonArray of(List<Json> value) {
        return new ArrayImpl(List.copyOf(value));
    }

    public static Builder builder() {
        return new ArrayBuilderImpl();
    }

    public static Builder builder(int initialCapacity) {
        return new ArrayBuilderImpl(initialCapacity);
    }

    public static Collector<JsonEncodable, ?, JsonArray> collector() {
        return Collector.of(JsonArray::builder, (A builder, T o) -> builder.add(o.toJson()), (a, b) -> {
            ArrayBuilderImpl impl = (ArrayBuilderImpl)b;
            a.addAll(impl.values());
            return a;
        }, Builder::build, new Collector.Characteristics[0]);
    }

    public static JsonArray empty() {
        return ArrayImpl.EMPTY;
    }

    public static sealed interface Builder
    extends JsonEncodable
    permits ArrayBuilderImpl {
        public Builder add(@Nullable Json var1);

        public Builder addAll(Collection<? extends @Nullable JsonEncodable> var1);

        default public Builder add(@Nullable JsonEncodable value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable BigDecimal value) {
            return this.add(Json.of(value));
        }

        default public Builder add(double value) {
            return this.add(Json.of(value));
        }

        default public Builder add(long value) {
            return this.add(Json.of(value));
        }

        default public Builder add(float value) {
            return this.add(Json.of(value));
        }

        default public Builder add(int value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable Double value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable Long value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable Float value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable Integer value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable BigInteger value) {
            return this.add(Json.of(value));
        }

        default public Builder add(@Nullable String value) {
            return this.add(Json.of(value));
        }

        default public Builder addNull() {
            return this.add(Json.ofNull());
        }

        default public Builder addTrue() {
            return this.add(Json.ofTrue());
        }

        default public Builder addFalse() {
            return this.add(Json.ofFalse());
        }

        default public Builder add(boolean b) {
            return this.add(Json.of(b));
        }

        default public Builder add(@Nullable Boolean b) {
            return this.add(Json.of(b));
        }

        public JsonArray build();

        @Override
        default public Json toJson() {
            return this.build();
        }
    }
}

