/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.JsonWriteOptions;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract sealed class JsonDecodeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    JsonDecodeException() {
    }

    JsonDecodeException(String message) {
        super(message);
    }

    JsonDecodeException(Throwable cause) {
        super(cause);
    }

    public static AtField atField(String fieldName, JsonDecodeException error) {
        return new AtField(fieldName, error);
    }

    public static AtIndex atIndex(int index, JsonDecodeException error) {
        return new AtIndex(index, error);
    }

    public static OneOf oneOf(List<JsonDecodeException> errors) {
        return new OneOf(errors);
    }

    public static Failure of(String message, Json value) {
        return new Failure(message, value);
    }

    public static Failure of(Throwable cause, Json value) {
        return new Failure(cause, value);
    }

    private static String indent(String string) {
        return String.join((CharSequence)"\n    ", string.split("\n"));
    }

    private static String getMessageHelp(JsonDecodeException error, ArrayList<String> context, boolean deep) {
        JsonDecodeException jsonDecodeException = error;
        Objects.requireNonNull(jsonDecodeException);
        JsonDecodeException jsonDecodeException2 = jsonDecodeException;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AtField.class, AtIndex.class, OneOf.class, Failure.class}, (Object)jsonDecodeException2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean isSimple;
                AtField atField = (AtField)jsonDecodeException2;
                Object fieldName = atField.fieldName();
                JsonDecodeException err = atField.error();
                if (((String)fieldName).isEmpty()) {
                    isSimple = false;
                } else {
                    isSimple = Character.isAlphabetic(((String)fieldName).charAt(0));
                    for (int i = 1; i < ((String)fieldName).length(); ++i) {
                        isSimple = isSimple && (Character.isAlphabetic(((String)fieldName).charAt(i)) || Character.isDigit(((String)fieldName).charAt(i)));
                    }
                }
                fieldName = isSimple ? "." + (String)fieldName : "[" + (String)fieldName + "]";
                context.add((String)fieldName);
                return JsonDecodeException.getMessageHelp(err, context, deep);
            }
            case 1: {
                AtIndex atIndex = (AtIndex)jsonDecodeException2;
                String indexName = "[" + atIndex.index() + "]";
                context.add(indexName);
                return JsonDecodeException.getMessageHelp(atIndex.error(), context, deep);
            }
            case 2: {
                OneOf oneOf = (OneOf)jsonDecodeException2;
                if (oneOf.errors().isEmpty()) {
                    return "Ran into oneOf with no possibilities" + (String)(context.isEmpty() ? "!" : " at json" + String.join((CharSequence)"", context));
                }
                if (oneOf.errors().size() == 1) {
                    return JsonDecodeException.getMessageHelp(oneOf.errors().get(0), context, deep);
                }
                StringBuilder msg = new StringBuilder();
                if (deep) {
                    String starter = context.isEmpty() ? "oneOf" : "oneOf at json" + String.join((CharSequence)"", context);
                    String introduction = starter + " failed in the following " + oneOf.errors().size() + " ways:";
                    msg.append(introduction);
                    msg.append("\n\n");
                    for (int i = 0; i < oneOf.errors().size(); ++i) {
                        msg.append("\n\n(");
                        msg.append(i + 1);
                        msg.append(") ");
                        msg.append(JsonDecodeException.indent(JsonDecodeException.getMessage(oneOf.errors().get(i))));
                        if (i == oneOf.errors().size() - 1) continue;
                        msg.append("\n\n");
                    }
                } else {
                    String starter = context.isEmpty() ? "oneOf" : "oneOf at json" + String.join((CharSequence)"", context);
                    String introduction = starter + " failed in the following " + oneOf.errors().size() + " ways:";
                    msg.append(introduction);
                    for (int i = 0; i < oneOf.errors().size(); ++i) {
                        msg.append("\n - (");
                        msg.append(i + 1);
                        msg.append(") ");
                        msg.append(JsonDecodeException.getMessage(oneOf.errors().get(i)));
                    }
                }
                return msg.toString();
            }
            case 3: 
        }
        Failure failure = (Failure)jsonDecodeException2;
        String msg = failure.getMessage();
        Json json = failure.value;
        if (deep) {
            String introduction = context.isEmpty() ? "Problem with the given value:\n\n    " : "Problem with the value at json" + String.join((CharSequence)"", context) + ":\n\n    ";
            return introduction + JsonDecodeException.indent(Json.writeString((JsonEncodable)json, new JsonWriteOptions().withIndentation(4))) + "\n\n" + msg;
        }
        String introduction = context.isEmpty() ? "Problem with the given value: " : "Problem with the value at json" + String.join((CharSequence)"", context) + ": ";
        return introduction + failure.getMessage();
    }

    public String getDetailedMessage() {
        return JsonDecodeException.getMessageHelp(this, new ArrayList<String>(), true);
    }

    protected static String getMessage(JsonDecodeException error) {
        return JsonDecodeException.getMessageHelp(error, new ArrayList<String>(), false);
    }

    public static final class AtField
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final JsonDecodeException error;

        private AtField(String fieldName, JsonDecodeException error) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            Objects.requireNonNull(error, "error must not be null");
            this.fieldName = fieldName;
            this.error = error;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public JsonDecodeException error() {
            return this.error;
        }

        @Override
        public String getMessage() {
            return AtField.getMessage(this);
        }
    }

    public static final class AtIndex
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final int index;
        private final JsonDecodeException error;

        private AtIndex(int index, JsonDecodeException error) {
            Objects.requireNonNull(error);
            this.index = index;
            this.error = error;
        }

        public int index() {
            return this.index;
        }

        public JsonDecodeException error() {
            return this.error;
        }

        @Override
        public String getMessage() {
            return AtIndex.getMessage(this);
        }
    }

    public static final class OneOf
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final List<JsonDecodeException> errors;

        private OneOf(List<JsonDecodeException> errors) {
            if (errors.size() == 0) {
                throw new IllegalArgumentException("errors must be non-empty");
            }
            Objects.requireNonNull(errors, "errors of errors must not be null");
            errors.forEach(error -> Objects.requireNonNull(error, "every error must not be null"));
            this.errors = List.copyOf(errors);
        }

        public List<JsonDecodeException> errors() {
            return this.errors;
        }

        @Override
        public String getMessage() {
            return OneOf.getMessage(this);
        }
    }

    public static final class Failure
    extends JsonDecodeException {
        private static final long serialVersionUID = 1L;
        private final Json value;

        private Failure(String reason, Json value) {
            super(reason);
            this.value = value;
        }

        private Failure(Throwable cause, Json value) {
            super(cause);
            this.value = value;
        }

        public Json value() {
            return this.value;
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }
    }
}

