/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonDecimal;
import dev.mccue.json.JsonInteger;
import dev.mccue.json.internal.JsonDecimalImpl;
import dev.mccue.json.internal.JsonIntegerImpl;
import dev.mccue.json.stream.JsonGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract sealed class JsonNumber
extends Number
implements Json
permits JsonDecimal, JsonInteger {
    private static final long serialVersionUID = 1L;

    protected JsonNumber() {
    }

    public abstract BigDecimal bigDecimalValue();

    public abstract BigInteger bigIntegerValue();

    public abstract int intValueExact();

    public abstract long longValueExact();

    public abstract BigInteger bigIntegerValueExact();

    public abstract boolean isIntegral();

    public static JsonDecimal of(BigDecimal value) {
        return new JsonDecimalImpl(value.toString());
    }

    public static JsonDecimal of(double value) {
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("JSON cannot encode an infinite value");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("JSON cannot encode a NaN");
        }
        return new JsonDecimalImpl(BigDecimal.valueOf(value).toString());
    }

    public static JsonInteger of(long value) {
        return new JsonIntegerImpl(BigDecimal.valueOf(value).toString());
    }

    public static JsonDecimal of(float value) {
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException("JSON cannot encode an infinite value");
        }
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException("JSON cannot encode a NaN");
        }
        return new JsonDecimalImpl(BigDecimal.valueOf(value).toString());
    }

    public static JsonInteger of(int value) {
        return new JsonIntegerImpl(BigDecimal.valueOf(value).toString());
    }

    public static JsonInteger of(BigInteger value) {
        return new JsonIntegerImpl(new BigDecimal(value).toString());
    }

    @Override
    public void write(JsonGenerator generator) {
        generator.writeNumber(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JsonNumber)) return false;
        JsonNumber otherNumber = (JsonNumber)obj;
        if (!this.bigDecimalValue().equals(otherNumber.bigDecimalValue())) return false;
        return true;
    }

    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }
}

