/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json;

import dev.mccue.json.Json;
import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.internal.ObjectBuilder;
import dev.mccue.json.internal.ObjectImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public sealed interface JsonObject
extends Json,
Map<String, Json>
permits ObjectImpl {
    public static JsonObject of(Map<String, ? extends @Nullable JsonEncodable> value) {
        return new ObjectImpl(value.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> {
            Objects.requireNonNull((String)entry.getKey(), "Json.Object cannot have null keys");
            return (String)entry.getKey();
        }, entry -> Json.of((JsonEncodable)entry.getValue()))));
    }

    public static Builder builder() {
        return new ObjectBuilder();
    }

    public static Builder builder(int initialCapacity) {
        return new ObjectBuilder(initialCapacity);
    }

    public static <T> Collector<T, ?, JsonObject> collector(Function<? super T, String> keyMapper, Function<? super T, ? extends JsonEncodable> valueMapper) {
        return Collector.of(JsonObject::builder, (builder, o) -> builder.put((String)keyMapper.apply(o), ((JsonEncodable)valueMapper.apply(o)).toJson()), (a, b) -> {
            ObjectBuilder impl = (ObjectBuilder)b;
            a.putAll(impl.values());
            return a;
        }, Builder::build, new Collector.Characteristics[0]);
    }

    public static JsonObject empty() {
        return ObjectImpl.EMPTY;
    }

    public static sealed interface Builder
    extends JsonEncodable
    permits ObjectBuilder {
        public Builder put(String var1, Json var2);

        default public Builder put(String key, @Nullable String value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable BigDecimal value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, double value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, long value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, float value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, int value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable Double value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable Long value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable Float value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable Integer value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable BigInteger value) {
            return this.put(key, Json.of(value));
        }

        default public Builder putNull(String key) {
            return this.put(key, Json.ofNull());
        }

        default public Builder putTrue(String key) {
            return this.put(key, Json.ofTrue());
        }

        default public Builder putFalse(String key) {
            return this.put(key, Json.ofFalse());
        }

        default public Builder put(String key, boolean value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable Boolean value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Collection<? extends @Nullable JsonEncodable> value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, Map<String, ? extends @Nullable JsonEncodable> value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable JsonEncodable value) {
            return this.put(key, Json.of(value));
        }

        default public Builder put(String key, @Nullable JsonObject value) {
            return this.put(key, (JsonEncodable)value);
        }

        default public Builder put(String key, @Nullable JsonArray value) {
            return this.put(key, (JsonEncodable)value);
        }

        public Builder putAll(Map<String, ? extends @Nullable JsonEncodable> var1);

        public JsonObject build();

        @Override
        default public Json toJson() {
            return this.build();
        }
    }
}

