/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonReadException;
import dev.mccue.json.JsonReadOptions;
import dev.mccue.json.internal.Handlers;
import dev.mccue.json.internal.JsonDecimalImpl;
import dev.mccue.json.internal.JsonIntegerImpl;
import dev.mccue.json.stream.JsonArrayHandler;
import dev.mccue.json.stream.JsonObjectHandler;
import dev.mccue.json.stream.JsonStreamReadOptions;
import dev.mccue.json.stream.JsonValueHandler;
import java.io.IOException;
import java.io.PushbackReader;
import org.jspecify.annotations.Nullable;

public final class JsonReaderMethods {
    private JsonReaderMethods() {
    }

    private static char readHexChar(PushbackReader stream) throws IOException {
        int a = stream.read();
        int b = stream.read();
        int c = stream.read();
        int d = stream.read();
        if (a < 0 || b < 0 || c < 0 || d < 0) {
            throw JsonReadException.unexpectedEOFInsideUnicodeCharacterEscape();
        }
        String s = String.valueOf(new char[]{(char)a, (char)b, (char)c, (char)d});
        try {
            return (char)Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            throw JsonReadException.invalidUnicodeCharacterEscape(e);
        }
    }

    private static char readEscapedChar(PushbackReader stream) throws IOException {
        int c = stream.read();
        if (c < 0) {
            throw JsonReadException.unexpectedEOFInsideEscapedChar();
        }
        return switch ((char)c) {
            case '\"', '/', '\\' -> (char)c;
            case 'b' -> 8;
            case 'f' -> 12;
            case 'n' -> 10;
            case 'r' -> 13;
            case 't' -> 9;
            case 'u' -> JsonReaderMethods.readHexChar(stream);
            default -> throw JsonReadException.invalidEscapeCharacter((char)c);
        };
    }

    private static String readQuotedString(PushbackReader stream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        block4: while (true) {
            int c;
            if ((c = stream.read()) < 0) {
                throw JsonReadException.unexpectedEOFInsideString();
            }
            switch ((char)c) {
                case '\"': {
                    return buffer.toString();
                }
                case '\\': {
                    buffer.append(JsonReaderMethods.readEscapedChar(stream));
                    continue block4;
                }
            }
            buffer.append((char)c);
        }
    }

    private static JsonNumber readInteger(String string) {
        return new JsonIntegerImpl(string);
    }

    private static JsonNumber readDecimal(String string) {
        return new JsonDecimalImpl(string);
    }

    private static JsonNumber readNumber(PushbackReader stream) throws IOException {
        boolean isDecimal;
        StringBuilder buffer = new StringBuilder();
        static enum Stage {
            MINUS,
            INT_ZERO,
            INT_DIGIT,
            FRAC_POINT,
            FRAC_FIRST,
            FRAC_DIGIT,
            EXP_SYMBOL,
            EXP_FIRST,
            EXP_DIGIT;

        }
        Stage stage = Stage.MINUS;
        block54: while (true) {
            int c = stream.read();
            switch (stage.ordinal()) {
                case 0: {
                    switch (c) {
                        case 45: {
                            buffer.append((char)c);
                            stage = Stage.INT_ZERO;
                            continue block54;
                        }
                        case 48: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_POINT;
                            continue block54;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.INT_DIGIT;
                            continue block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 1: {
                    switch (c) {
                        case 48: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_POINT;
                            continue block54;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.INT_DIGIT;
                            continue block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 2: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            continue block54;
                        }
                        case 46: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_FIRST;
                            continue block54;
                        }
                        case 69: 
                        case 101: {
                            buffer.append((char)c);
                            stage = Stage.EXP_SYMBOL;
                            continue block54;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = false;
                            break block54;
                        }
                        case -1: {
                            isDecimal = false;
                            break block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 3: {
                    switch (c) {
                        case 46: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_FIRST;
                            continue block54;
                        }
                        case 69: 
                        case 101: {
                            buffer.append((char)c);
                            stage = Stage.EXP_SYMBOL;
                            continue block54;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = false;
                            break block54;
                        }
                        case -1: {
                            isDecimal = false;
                            break block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 4: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.FRAC_DIGIT;
                            continue block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 5: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            continue block54;
                        }
                        case 69: 
                        case 101: {
                            buffer.append((char)c);
                            stage = Stage.EXP_SYMBOL;
                            continue block54;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = true;
                            break block54;
                        }
                        case -1: {
                            isDecimal = true;
                            break block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 6: {
                    switch (c) {
                        case 43: 
                        case 45: {
                            buffer.append((char)c);
                            stage = Stage.EXP_FIRST;
                            continue block54;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.EXP_DIGIT;
                            continue block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 7: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            stage = Stage.EXP_DIGIT;
                            continue block54;
                        }
                    }
                    throw JsonReadException.invalidNumberLiteral();
                }
                case 8: {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            buffer.append((char)c);
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: 
                        case 93: 
                        case 125: {
                            stream.unread(c);
                            isDecimal = true;
                            break block54;
                        }
                        case -1: {
                            isDecimal = true;
                            break block54;
                        }
                        default: {
                            throw JsonReadException.invalidNumberLiteral();
                        }
                    }
                }
                default: {
                    continue block54;
                }
            }
            break;
        }
        if (isDecimal) {
            return JsonReaderMethods.readDecimal(buffer.toString());
        }
        return JsonReaderMethods.readInteger(buffer.toString());
    }

    private static int nextToken(PushbackReader stream) throws IOException {
        int c = stream.read();
        block4: while (true) {
            if (32 < c) {
                return c;
            }
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    c = stream.read();
                    continue block4;
                }
                case -1: {
                    return -1;
                }
            }
            break;
        }
        throw JsonReadException.invalidToken();
    }

    private static @Nullable String readKey(PushbackReader stream) throws IOException {
        int c = JsonReaderMethods.nextToken(stream);
        if (c == 34) {
            String key = JsonReaderMethods.readQuotedString(stream);
            if (58 == JsonReaderMethods.nextToken(stream)) {
                return key;
            }
            throw JsonReadException.missingColonInObject();
        }
        if (c == 125) {
            return null;
        }
        throw JsonReadException.nonStringKeyInObject((char)c);
    }

    private static boolean readUll(PushbackReader stream) throws IOException {
        return stream.read() == 117 && stream.read() == 108 && stream.read() == 108;
    }

    private static boolean readRue(PushbackReader stream) throws IOException {
        return stream.read() == 114 && stream.read() == 117 && stream.read() == 101;
    }

    private static boolean readAlse(PushbackReader stream) throws IOException {
        return stream.read() == 97 && stream.read() == 108 && stream.read() == 115 && stream.read() == 101;
    }

    private static void readArrayHelperStream(PushbackReader stream, JsonStreamReadOptions options, JsonArrayHandler arrayHandler) throws IOException {
        block4: while (true) {
            JsonReaderMethods.readStream(stream, true, options, arrayHandler);
            switch ((char)JsonReaderMethods.nextToken(stream)) {
                case ']': {
                    arrayHandler.onArrayEnd();
                    return;
                }
                case ',': {
                    continue block4;
                }
            }
            break;
        }
        throw JsonReadException.invalidArray();
    }

    private static void readArrayStream(PushbackReader stream, JsonStreamReadOptions options, JsonValueHandler valueHandler) throws IOException {
        JsonArrayHandler arrayHandler = valueHandler.onArrayStart();
        int c = JsonReaderMethods.nextToken(stream);
        switch (c) {
            case 93: {
                arrayHandler.onArrayEnd();
                break;
            }
            case 44: {
                throw JsonReadException.invalidArray();
            }
            default: {
                stream.unread(c);
                JsonReaderMethods.readArrayHelperStream(stream, options, arrayHandler);
            }
        }
    }

    private static void readObjectStream(PushbackReader stream, JsonStreamReadOptions options, JsonValueHandler valueHandler) throws IOException {
        String key;
        boolean readSomeEntry = false;
        JsonObjectHandler objectHandler = valueHandler.onObjectStart();
        block4: while ((key = JsonReaderMethods.readKey(stream)) != null) {
            readSomeEntry = true;
            JsonValueHandler fieldHandler = objectHandler.onField(key);
            JsonReaderMethods.readStream(stream, true, options, fieldHandler);
            switch (JsonReaderMethods.nextToken(stream)) {
                case 44: {
                    continue block4;
                }
                case 125: {
                    objectHandler.onObjectEnd();
                    return;
                }
            }
            throw JsonReadException.missingEntryInObject();
        }
        if (readSomeEntry) {
            throw JsonReadException.emptyEntryInObject();
        }
        objectHandler.onObjectEnd();
    }

    public static void readStream(PushbackReader stream, boolean throwIfEofEncountered, JsonStreamReadOptions options, JsonValueHandler valueHandler) throws IOException {
        int c = JsonReaderMethods.nextToken(stream);
        switch (c) {
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                stream.unread(c);
                valueHandler.onNumber(JsonReaderMethods.readNumber(stream));
                break;
            }
            case 34: {
                valueHandler.onString(JsonReaderMethods.readQuotedString(stream));
                break;
            }
            case 110: {
                if (JsonReaderMethods.readUll(stream)) {
                    valueHandler.onNull();
                    break;
                }
                throw JsonReadException.expectedNull();
            }
            case 116: {
                if (JsonReaderMethods.readRue(stream)) {
                    valueHandler.onTrue();
                    break;
                }
                throw JsonReadException.expectedTrue();
            }
            case 102: {
                if (JsonReaderMethods.readAlse(stream)) {
                    valueHandler.onFalse();
                    break;
                }
                throw JsonReadException.expectedFalse();
            }
            case 123: {
                JsonReaderMethods.readObjectStream(stream, options, valueHandler);
                break;
            }
            case 91: {
                JsonReaderMethods.readArrayStream(stream, options, valueHandler);
                break;
            }
            default: {
                if (c < 0) {
                    if (!throwIfEofEncountered) break;
                    throw JsonReadException.unexpectedEOF();
                }
                throw JsonReadException.unexpectedCharacter((char)c);
            }
        }
    }

    public static Json read(PushbackReader stream, JsonReadOptions options) throws IOException {
        Handlers.BaseTreeValueHandler handler = new Handlers.BaseTreeValueHandler();
        JsonReaderMethods.readStream(stream, false, new JsonStreamReadOptions(), handler);
        if (handler.result == null && options.eofBehavior() == JsonReadOptions.EOFBehavior.THROW_EXCEPTION) {
            throw JsonReadException.unexpectedEOF();
        }
        return handler.result;
    }

    public static Json readFullyConsume(PushbackReader stream, JsonReadOptions options) throws IOException {
        Json result = JsonReaderMethods.read(stream, options);
        int c = stream.read();
        while (c > 0) {
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    throw JsonReadException.nonWhitespaceTrailingContents((char)c);
                }
            }
            c = stream.read();
        }
        return result;
    }
}

