/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonArray;
import dev.mccue.json.JsonFalse;
import dev.mccue.json.JsonNull;
import dev.mccue.json.JsonNumber;
import dev.mccue.json.JsonObject;
import dev.mccue.json.JsonString;
import dev.mccue.json.JsonTrue;
import dev.mccue.json.JsonWriteOptions;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class JsonWriter {
    private static final short[] CODEPOINT_DECODER = new short[128];

    private static void emitHexString(Appendable out, char cp) throws IOException {
        out.append("\\u");
        if (cp < '\u0010') {
            out.append("000");
        } else if (cp < '\u0100') {
            out.append("00");
        } else if (cp < '\u1000') {
            out.append("0");
        }
        out.append(Integer.toHexString(cp));
    }

    public static void writeString(CharSequence s, Appendable out, OptionsWithIndentDepth options) throws IOException {
        out.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char cp = s.charAt(i);
            if (cp < '\u0080') {
                switch (CODEPOINT_DECODER[cp]) {
                    case 0: {
                        out.append(cp);
                        break;
                    }
                    case 1: {
                        out.append('\\');
                        out.append(cp);
                        break;
                    }
                    case 2: {
                        if (options.escapeSlash()) {
                            out.append("\\/");
                            break;
                        }
                        out.append("/");
                        break;
                    }
                    case 3: {
                        out.append("\\b");
                        break;
                    }
                    case 4: {
                        out.append("\\f");
                        break;
                    }
                    case 5: {
                        out.append("\\n");
                        break;
                    }
                    case 6: {
                        out.append("\\r");
                        break;
                    }
                    case 7: {
                        out.append("\\t");
                        break;
                    }
                    case 8: {
                        JsonWriter.emitHexString(out, cp);
                    }
                }
                continue;
            }
            if (cp == '\u2028' || cp == '\u2029') {
                if (options.escapeJavascriptSeparators()) {
                    JsonWriter.emitHexString(out, cp);
                    continue;
                }
                out.append(cp);
                continue;
            }
            if (options.escapeUnicode()) {
                JsonWriter.emitHexString(out, cp);
                continue;
            }
            out.append(cp);
        }
        out.append('\"');
    }

    static void writeIndent(Appendable out, OptionsWithIndentDepth options) throws IOException {
        out.append('\n');
        out.append(" ".repeat(options.indentation() * options.indentDepth));
    }

    static void writeObject(JsonObject m, Appendable out, OptionsWithIndentDepth options) throws IOException {
        boolean indent = options.indent();
        OptionsWithIndentDepth opts = indent ? options.incrementIndentDepth() : options;
        out.append('{');
        if (indent && !m.isEmpty()) {
            JsonWriter.writeIndent(out, opts);
        }
        Iterator x = m.entrySet().iterator();
        boolean havePrintedKV = false;
        while (x.hasNext()) {
            Map.Entry entry = x.next();
            String k = (String)entry.getKey();
            Json v = (Json)entry.getValue();
            if (havePrintedKV) {
                out.append(',');
                if (indent) {
                    JsonWriter.writeIndent(out, opts);
                }
            }
            JsonWriter.writeString(k, out, opts);
            out.append(':');
            if (indent) {
                out.append(' ');
            }
            JsonWriter.write(v, out, opts);
            if (!x.hasNext()) continue;
            havePrintedKV = true;
        }
        if (indent && !m.isEmpty()) {
            JsonWriter.writeIndent(out, options);
        }
        out.append('}');
    }

    static void writeArray(JsonArray a, Appendable out, OptionsWithIndentDepth options) throws IOException {
        boolean indent = options.indent();
        OptionsWithIndentDepth opts = indent ? options.incrementIndentDepth() : options;
        out.append('[');
        if (indent && !a.isEmpty()) {
            JsonWriter.writeIndent(out, opts);
        }
        Iterator x = a.iterator();
        while (x.hasNext()) {
            Json first = (Json)x.next();
            JsonWriter.write(first, out, opts);
            if (!x.hasNext()) continue;
            out.append(',');
            if (!indent) continue;
            JsonWriter.writeIndent(out, opts);
        }
        if (indent && !a.isEmpty()) {
            JsonWriter.writeIndent(out, options);
        }
        out.append(']');
    }

    static void write(Json v, Appendable out, OptionsWithIndentDepth options) throws IOException {
        Json json = v;
        Objects.requireNonNull(json);
        Json json2 = json;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNull.class, JsonTrue.class, JsonFalse.class, JsonNumber.class, JsonString.class, JsonArray.class, JsonObject.class}, (Object)json2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonNull __ = (JsonNull)json2;
                out.append("null");
                break;
            }
            case 1: {
                JsonTrue __ = (JsonTrue)json2;
                out.append("true");
                break;
            }
            case 2: {
                JsonFalse __ = (JsonFalse)json2;
                out.append("false");
                break;
            }
            case 3: {
                JsonNumber number = (JsonNumber)json2;
                out.append(number.toString());
                break;
            }
            case 4: {
                JsonString string = (JsonString)json2;
                JsonWriter.writeString(string, out, options);
                break;
            }
            case 5: {
                JsonArray array = (JsonArray)json2;
                JsonWriter.writeArray(array, out, options);
                break;
            }
            case 6: {
                JsonObject object = (JsonObject)json2;
                JsonWriter.writeObject(object, out, options);
            }
        }
    }

    public void write(Json json, Appendable out, JsonWriteOptions options) throws IOException {
        JsonWriter.write(json, out, new OptionsWithIndentDepth(options));
    }

    static {
        for (int i = 0; i < 128; ++i) {
            JsonWriter.CODEPOINT_DECODER[i] = switch (i) {
                case 34, 92 -> 1;
                case 47 -> 2;
                case 8 -> 3;
                case 12 -> 4;
                case 10 -> 5;
                case 13 -> 6;
                case 9 -> 7;
                default -> i < 32 ? 8 : 0;
            };
        }
    }

    public record OptionsWithIndentDepth(JsonWriteOptions options, int indentDepth) {
        OptionsWithIndentDepth(JsonWriteOptions options) {
            this(options, 0);
        }

        boolean escapeUnicode() {
            return this.options.escapeUnicode();
        }

        boolean escapeJavascriptSeparators() {
            return this.options.escapeJavascriptSeparators();
        }

        boolean escapeSlash() {
            return this.options.escapeSlash();
        }

        int indentation() {
            return this.options.indentation();
        }

        boolean indent() {
            return this.indentation() != 0;
        }

        OptionsWithIndentDepth incrementIndentDepth() {
            return new OptionsWithIndentDepth(this.options, this.indentDepth + 1);
        }
    }
}

