/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.internal;

import dev.mccue.json.Json;
import dev.mccue.json.JsonEncodable;
import dev.mccue.json.JsonString;
import dev.mccue.json.serialization.JsonSerializationProxy;
import dev.mccue.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.stream.IntStream;

public final class StringImpl
implements JsonString {
    private static final long serialVersionUID = 1L;
    private final String value;

    public StringImpl(String value) {
        this.value = Objects.requireNonNull(value, "Json.String value must be nonnull");
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    @Override
    public String toString() {
        return this.value;
    }

    private Object writeReplace() {
        return new JsonSerializationProxy(Json.writeString((JsonEncodable)this));
    }

    private Object readResolve() {
        throw new IllegalStateException();
    }

    @Override
    public void write(JsonGenerator generator) {
        generator.writeString(this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof StringImpl)) return false;
        StringImpl impl = (StringImpl)obj;
        if (!this.value.equals(impl.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

