/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.json.stream;

import dev.mccue.json.JsonNumber;
import dev.mccue.json.stream.JsonEvent;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public interface JsonGenerator {
    public void writeObjectStart();

    public void writeObjectEnd();

    public void writeArrayStart();

    public void writeArrayEnd();

    public void writeFieldName(String var1);

    public void writeString(String var1);

    public void writeNumber(JsonNumber var1);

    public void writeTrue();

    public void writeFalse();

    public void writeNull();

    default public void write(JsonEvent event) {
        JsonEvent jsonEvent = event;
        Objects.requireNonNull(jsonEvent);
        JsonEvent jsonEvent2 = jsonEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonEvent.ObjectStart.class, JsonEvent.ObjectEnd.class, JsonEvent.ArrayStart.class, JsonEvent.ArrayEnd.class, JsonEvent.Field.class, JsonEvent.String.class, JsonEvent.Number.class, JsonEvent.True.class, JsonEvent.False.class, JsonEvent.Null.class}, (Object)jsonEvent2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonEvent.ObjectStart __ = (JsonEvent.ObjectStart)jsonEvent2;
                this.writeObjectStart();
                break;
            }
            case 1: {
                JsonEvent.ObjectEnd __ = (JsonEvent.ObjectEnd)jsonEvent2;
                this.writeObjectEnd();
                break;
            }
            case 2: {
                JsonEvent.ArrayStart __ = (JsonEvent.ArrayStart)jsonEvent2;
                this.writeArrayStart();
                break;
            }
            case 3: {
                JsonEvent.ArrayEnd __ = (JsonEvent.ArrayEnd)jsonEvent2;
                this.writeArrayEnd();
                break;
            }
            case 4: {
                JsonEvent.Field field = (JsonEvent.Field)jsonEvent2;
                this.writeFieldName(field.name());
                break;
            }
            case 5: {
                JsonEvent.String string = (JsonEvent.String)jsonEvent2;
                this.writeString(string.value());
                break;
            }
            case 6: {
                JsonEvent.Number number = (JsonEvent.Number)jsonEvent2;
                this.writeNumber(number.value());
                break;
            }
            case 7: {
                JsonEvent.True __ = (JsonEvent.True)jsonEvent2;
                this.writeTrue();
                break;
            }
            case 8: {
                JsonEvent.False __ = (JsonEvent.False)jsonEvent2;
                this.writeFalse();
                break;
            }
            case 9: {
                JsonEvent.Null __ = (JsonEvent.Null)jsonEvent2;
                this.writeNull();
            }
        }
    }

    default public void writeNumber(float value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(double value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(int value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(long value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(BigInteger value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumber(BigDecimal value) {
        this.writeNumber(JsonNumber.of(value));
    }

    default public void writeNumberField(String fieldName, JsonNumber number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, float number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, double number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, int number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, long number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, BigInteger number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeNumberField(String fieldName, BigDecimal number) {
        this.writeFieldName(fieldName);
        this.writeNumber(number);
    }

    default public void writeStringField(String fieldName, String value) {
        this.writeFieldName(fieldName);
        this.writeString(value);
    }

    default public void writeNullField(String fieldName) {
        this.writeFieldName(fieldName);
        this.writeNull();
    }
}

