/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.microhttp.handler;

import dev.mccue.microhttp.handler.Handler;
import dev.mccue.microhttp.handler.IntoResponse;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.microhttp.Request;

public abstract class RouteHandler
implements Handler {
    private final String method;
    private final Pattern pattern;

    protected RouteHandler(String method, Pattern pattern) {
        this.method = Objects.requireNonNull(method);
        this.pattern = Objects.requireNonNull(pattern);
    }

    protected abstract @Nullable IntoResponse handleRoute(Matcher var1, Request var2) throws Exception;

    public static RouteHandler of(String method, Pattern pattern, final Handler handler) {
        return new RouteHandler(method, pattern){

            @Override
            protected @Nullable IntoResponse handleRoute(Matcher routeMatch, Request request) throws Exception {
                return handler.handle(request);
            }
        };
    }

    public static RouteHandler of(String method, Pattern pattern, final MatcherHandler handler) {
        return new RouteHandler(method, pattern){

            @Override
            protected @Nullable IntoResponse handleRoute(Matcher routeMatch, Request request) throws Exception {
                return handler.handleRoute(routeMatch, request);
            }
        };
    }

    @Override
    public final @Nullable IntoResponse handle(Request request) throws Exception {
        if (!this.method.equalsIgnoreCase(request.method())) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(new URI(request.uri()).getPath());
        if (!matcher.matches()) {
            return null;
        }
        return this.handleRoute(matcher, request);
    }

    public static interface MatcherHandler {
        public @Nullable IntoResponse handleRoute(Matcher var1, Request var2) throws Exception;
    }
}

