/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve;

import dev.mccue.resolve.Artifact;
import dev.mccue.resolve.Exclusion;
import dev.mccue.resolve.Group;
import dev.mccue.resolve.Library;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Exclusions {
    public static final Exclusions NONE = new Exclusions(ExcludeNone.INSTANCE);
    public static final Exclusions ALL = new Exclusions(ExcludeAll.INSTANCE);
    private int hash = 0;
    private final ExclusionData exclusionData;

    private Exclusions(ExclusionData exclusionData) {
        this.exclusionData = Objects.requireNonNull(exclusionData, "exclusionData must not be null");
    }

    public static Exclusions of(Set<Exclusion> exclusions) {
        return Exclusions.of(List.copyOf(exclusions));
    }

    public static Exclusions of(Exclusion ... exclusions) {
        return Exclusions.of(Arrays.asList(exclusions));
    }

    public static Exclusions of(List<Exclusion> exclusions) {
        if (exclusions.isEmpty()) {
            return NONE;
        }
        HashSet<Group> excludeByGroup0 = new HashSet<Group>();
        HashSet<Artifact> excludeByArtifact0 = new HashSet<Artifact>();
        HashSet<Exclusion> remaining0 = new HashSet<Exclusion>();
        for (Exclusion exclusion2 : exclusions) {
            if (Group.ALL.equals(exclusion2.group())) {
                if (Artifact.ALL.equals(exclusion2.artifact())) {
                    return ALL;
                }
                excludeByArtifact0.add(exclusion2.artifact());
                continue;
            }
            if (Artifact.ALL.equals(exclusion2.artifact())) {
                excludeByGroup0.add(exclusion2.group());
                continue;
            }
            remaining0.add(exclusion2);
        }
        return new Exclusions(new ExcludeSpecific(Set.copyOf(excludeByGroup0), Set.copyOf(excludeByArtifact0), remaining0.stream().filter(exclusion -> !excludeByGroup0.contains(exclusion.group()) && !excludeByArtifact0.contains(exclusion.artifact())).collect(Collectors.toUnmodifiableSet())));
    }

    public boolean shouldInclude(Library library) {
        return this.exclusionData.shouldInclude(library.group(), library.artifact());
    }

    public Exclusions join(Exclusions other) {
        ExclusionData newData = this.exclusionData.join(other.exclusionData);
        if (newData == this.exclusionData) {
            return this;
        }
        if (newData == other.exclusionData) {
            return other;
        }
        return new Exclusions(newData);
    }

    public Exclusions meet(Exclusions other) {
        ExclusionData newData = this.exclusionData.meet(other.exclusionData);
        if (newData == this.exclusionData) {
            return this;
        }
        if (newData == other.exclusionData) {
            return other;
        }
        return new Exclusions(newData);
    }

    public Exclusions map(Function<String, String> f) {
        ExclusionData newData = this.exclusionData.map(f);
        if (newData == this.exclusionData) {
            return this;
        }
        return new Exclusions(newData);
    }

    public int size() {
        return this.exclusionData.size();
    }

    public boolean subsetOf(Exclusions other) {
        return this.exclusionData.subsetOf(other.exclusionData);
    }

    public Set<Exclusion> toSet() {
        return this.exclusionData.toSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Exclusions)) return false;
        Exclusions exclusions = (Exclusions)obj;
        if (!this.exclusionData.equals(exclusions.exclusionData)) return false;
        return true;
    }

    public int hashCode() {
        int cached = this.hash;
        if (cached == 0) {
            this.hash = cached = this.exclusionData.hashCode();
            return cached;
        }
        return this.hash;
    }

    public String toString() {
        return this.exclusionData.toString();
    }

    static sealed interface ExclusionData
    permits ExcludeNone, ExcludeAll, ExcludeSpecific {
        public boolean shouldInclude(Group var1, Artifact var2);

        public ExclusionData join(ExclusionData var1);

        public ExclusionData meet(ExclusionData var1);

        public ExclusionData map(Function<String, String> var1);

        public int size();

        public boolean subsetOf(ExclusionData var1);

        public Set<Exclusion> toSet();
    }

    record ExcludeSpecific(Set<Group> byGroup, Set<Artifact> byArtifact, Set<Exclusion> specific) implements ExclusionData
    {
        public ExcludeSpecific(Set<Group> byGroup, Set<Artifact> byArtifact, Set<Exclusion> specific) {
            this.byGroup = Set.copyOf(byGroup);
            this.byArtifact = Set.copyOf(byArtifact);
            this.specific = Set.copyOf(specific);
        }

        @Override
        public boolean shouldInclude(Group group, Artifact artifact) {
            return !this.byGroup.contains(group) && !this.byArtifact.contains(artifact) && !this.specific.contains(new Exclusion(group, artifact));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ExclusionData join(ExclusionData other) {
            HashSet<Group> joinedByGroup;
            Set<Record> otherSpecific;
            Set<Record> otherByArtifact;
            Set<Group> otherByOrg;
            ExclusionData exclusionData;
            ExclusionData exclusionData2 = other;
            Objects.requireNonNull(exclusionData2);
            ExclusionData exclusionData22 = exclusionData2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExcludeNone.class, ExcludeAll.class, ExcludeSpecific.class}, (Object)exclusionData22, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ExcludeNone __ = (ExcludeNone)exclusionData22;
                    exclusionData = this;
                    return exclusionData;
                }
                case 1: {
                    ExcludeAll all = (ExcludeAll)exclusionData22;
                    exclusionData = all;
                    return exclusionData;
                }
                case 2: 
            }
            ExcludeSpecific excludeSpecific = (ExcludeSpecific)exclusionData22;
            try {
                Set<Record> set = excludeSpecific.byGroup();
                otherByOrg = set;
                set = excludeSpecific.byArtifact();
                otherByArtifact = set;
                otherSpecific = set = excludeSpecific.specific();
                joinedByGroup = new HashSet<Group>();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            joinedByGroup.addAll(this.byGroup);
            joinedByGroup.addAll(otherByOrg);
            HashSet<Record> joinedByArtifact = new HashSet<Record>();
            joinedByArtifact.addAll(this.byArtifact);
            joinedByArtifact.addAll(otherByArtifact);
            HashSet joinedSpecific = new HashSet();
            this.specific.stream().filter(exclusion -> !otherByOrg.contains(exclusion.group()) && !otherByArtifact.contains(exclusion.artifact())).forEach(joinedSpecific::add);
            otherSpecific.stream().filter(exclusion -> !this.byGroup.contains(exclusion.group()) && !this.byArtifact.contains(exclusion.artifact())).forEach(joinedSpecific::add);
            exclusionData = new ExcludeSpecific(Set.copyOf(joinedByGroup), Set.copyOf(joinedByArtifact), Set.copyOf(joinedSpecific));
            return exclusionData;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ExclusionData meet(ExclusionData other) {
            Set<Record> otherSpecific;
            Set<Record> otherByArtifact;
            Set<Group> otherByGroup;
            ExclusionData exclusionData;
            ExclusionData exclusionData2 = other;
            Objects.requireNonNull(exclusionData2);
            ExclusionData exclusionData22 = exclusionData2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExcludeNone.class, ExcludeAll.class, ExcludeSpecific.class}, (Object)exclusionData22, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ExcludeNone none;
                    exclusionData = none = (ExcludeNone)exclusionData22;
                    return exclusionData;
                }
                case 1: {
                    ExcludeAll __ = (ExcludeAll)exclusionData22;
                    exclusionData = this;
                    return exclusionData;
                }
                case 2: 
            }
            ExcludeSpecific excludeSpecific = (ExcludeSpecific)exclusionData22;
            try {
                Set<Record> set = excludeSpecific.byGroup();
                otherByGroup = set;
                set = excludeSpecific.byArtifact();
                otherByArtifact = set;
                otherSpecific = set = excludeSpecific.specific();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Set<Group> metByGroup = this.byGroup.stream().filter(otherByGroup::contains).collect(Collectors.toUnmodifiableSet());
            Set<Artifact> metByArtifact = this.byArtifact.stream().filter(otherByArtifact::contains).collect(Collectors.toUnmodifiableSet());
            HashSet metSpecific = new HashSet();
            this.specific.stream().filter(exclusion -> {
                Group group = exclusion.group();
                Artifact artifact = exclusion.artifact();
                return otherByGroup.contains(group) || otherByArtifact.contains(artifact) || otherSpecific.contains(exclusion);
            }).forEach(metSpecific::add);
            otherSpecific.stream().filter(exclusion -> {
                Group group = exclusion.group();
                Artifact artifact = exclusion.artifact();
                return this.byGroup.contains(group) || this.byArtifact.contains(artifact) || this.specific.contains(exclusion);
            }).forEach(metSpecific::add);
            if (metByGroup.isEmpty() && metByArtifact.isEmpty() && metSpecific.isEmpty()) {
                exclusionData = ExcludeNone.INSTANCE;
                return exclusionData;
            }
            exclusionData = new ExcludeSpecific(metByGroup, metByArtifact, Set.copyOf(metSpecific));
            return exclusionData;
        }

        @Override
        public ExclusionData map(Function<String, String> f) {
            return new ExcludeSpecific(this.byGroup.stream().map((? super T group) -> group.map(f)).collect(Collectors.toUnmodifiableSet()), this.byArtifact.stream().map((? super T artifact) -> artifact.map(f)).collect(Collectors.toUnmodifiableSet()), this.specific.stream().map((? super T exclusion) -> new Exclusion(exclusion.group().map(f), exclusion.artifact().map(f))).collect(Collectors.toUnmodifiableSet()));
        }

        @Override
        public int size() {
            return this.byGroup.size() + this.byArtifact().size() + this.specific.size();
        }

        @Override
        public boolean subsetOf(ExclusionData other) {
            ExclusionData exclusionData = other;
            Objects.requireNonNull(exclusionData);
            ExclusionData exclusionData2 = exclusionData;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExcludeNone.class, ExcludeAll.class, ExcludeSpecific.class}, (Object)exclusionData2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ExcludeNone __ = (ExcludeNone)exclusionData2;
                    yield false;
                }
                case 1 -> {
                    ExcludeAll __ = (ExcludeAll)exclusionData2;
                    yield true;
                }
                case 2 -> {
                    ExcludeSpecific excludeSpecific = (ExcludeSpecific)exclusionData2;
                    yield excludeSpecific.byGroup.containsAll(this.byGroup) && excludeSpecific.byArtifact.containsAll(this.byArtifact) && excludeSpecific.specific.containsAll(this.specific);
                }
            };
        }

        @Override
        public Set<Exclusion> toSet() {
            HashSet<Exclusion> set = new HashSet<Exclusion>();
            this.byGroup.stream().map((? super T group) -> new Exclusion((Group)group, Artifact.ALL)).forEach(set::add);
            this.byArtifact.stream().map((? super T artifact) -> new Exclusion(Group.ALL, (Artifact)artifact)).forEach(set::add);
            set.addAll(this.specific);
            return Set.copyOf(set);
        }
    }

    static enum ExcludeNone implements ExclusionData
    {
        INSTANCE;


        @Override
        public boolean shouldInclude(Group group, Artifact artifact) {
            return true;
        }

        @Override
        public ExclusionData join(ExclusionData other) {
            return other;
        }

        @Override
        public ExclusionData meet(ExclusionData other) {
            return INSTANCE;
        }

        @Override
        public ExclusionData map(Function<String, String> f) {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean subsetOf(ExclusionData other) {
            return true;
        }

        @Override
        public Set<Exclusion> toSet() {
            return Set.of();
        }

        public String toString() {
            return "ExcludeNone";
        }
    }

    static enum ExcludeAll implements ExclusionData
    {
        INSTANCE;


        @Override
        public boolean shouldInclude(Group group, Artifact artifact) {
            return false;
        }

        @Override
        public ExclusionData join(ExclusionData other) {
            return this;
        }

        @Override
        public ExclusionData meet(ExclusionData other) {
            return other;
        }

        @Override
        public ExclusionData map(Function<String, String> f) {
            return this;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean subsetOf(ExclusionData other) {
            return this.equals(other);
        }

        @Override
        public Set<Exclusion> toSet() {
            return Set.of(new Exclusion(Group.ALL, Artifact.ALL));
        }

        public String toString() {
            return "ExcludeAll";
        }
    }
}

