/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve;

import dev.mccue.resolve.Cache;
import dev.mccue.resolve.Dependency;
import dev.mccue.resolve.Library;
import dev.mccue.resolve.Resolve;
import java.io.File;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class Fetch {
    private final Supplier<? extends @Nullable Resolve.Result> resolutionSupplier;
    private final List<Dependency> dependencies;
    private @Nullable Cache cache;
    private boolean includeLibraries;
    private boolean includeSources;
    private boolean includeDocumentation;
    private ExecutorService executorService;

    public Fetch(Resolve resolve) {
        this(resolve::run, List.of(), resolve.cache);
    }

    public Fetch(Resolve.Result result) {
        this(() -> result, List.of(), Cache.standard());
    }

    public Fetch(List<Dependency> dependencies) {
        this(() -> null, dependencies, Cache.standard());
    }

    private Fetch(Supplier<Resolve.Result> resolutionSupplier, List<Dependency> dependencies, Cache cache) {
        this.resolutionSupplier = resolutionSupplier;
        this.dependencies = List.copyOf(dependencies);
        AtomicInteger count = new AtomicInteger();
        this.executorService = Executors.newFixedThreadPool(8, r -> {
            Thread t = new Thread(r);
            t.setName("fetch-" + count.getAndIncrement());
            t.setDaemon(true);
            return t;
        });
        this.cache = cache;
        this.includeLibraries = true;
        this.includeSources = false;
        this.includeDocumentation = false;
    }

    public Fetch withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public Fetch withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Fetch includeLibraries(boolean includeLibraries) {
        this.includeLibraries = includeLibraries;
        return this;
    }

    public Fetch includeSources(boolean includeSources) {
        this.includeSources = includeSources;
        return this;
    }

    public Fetch includeSources() {
        return this.includeSources(true);
    }

    public Fetch includeDocumentation(boolean includeDocumentation) {
        this.includeDocumentation = includeDocumentation;
        return this;
    }

    public Fetch includeDocumentation() {
        return this.includeDocumentation(true);
    }

    public Result run() {
        Resolve.Result resolution = this.resolutionSupplier.get();
        ArrayList<Dependency> selectedDependencies = new ArrayList<Dependency>();
        if (resolution != null) {
            selectedDependencies.addAll(resolution.selectedDependencies());
        }
        selectedDependencies.addAll(this.dependencies);
        HashMap<Library, Future> futurePaths = new HashMap<Library, Future>();
        if (this.includeLibraries) {
            selectedDependencies.forEach(dependency -> futurePaths.put(dependency.library(), this.executorService.submit(() -> dependency.coordinate().getLibraryLocation(this.cache))));
        }
        HashMap<Library, Future> futureSources = new HashMap<Library, Future>();
        if (this.includeSources) {
            selectedDependencies.forEach(dependency -> futureSources.put(dependency.library(), this.executorService.submit(() -> dependency.coordinate().getLibrarySourcesLocation(this.cache))));
        }
        HashMap<Library, Future> futureDocumentation = new HashMap<Library, Future>();
        if (this.includeDocumentation) {
            selectedDependencies.forEach(dependency -> futureDocumentation.put(dependency.library(), this.executorService.submit(() -> dependency.coordinate().getLibraryDocumentationLocation(this.cache))));
        }
        HashMap libraries = new HashMap();
        futurePaths.forEach((k, v) -> {
            try {
                libraries.put(k, (Path)v.get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        HashMap sources = new HashMap();
        futureSources.forEach((k, v) -> {
            try {
                ((Optional)v.get()).ifPresent(path -> sources.put(k, path));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        HashMap documentation = new HashMap();
        futureDocumentation.forEach((k, v) -> {
            try {
                ((Optional)v.get()).ifPresent(path -> documentation.put(k, path));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return new Result(Map.copyOf(libraries), Map.copyOf(sources), Map.copyOf(documentation));
    }

    public record Result(Map<Library, Path> libraries, Map<Library, Path> sources, Map<Library, Path> documentation) {
        public Result {
            Objects.requireNonNull(libraries);
            Objects.requireNonNull(sources);
            Objects.requireNonNull(documentation);
        }

        public String path(List<Path> extraPaths) {
            return Stream.concat(this.libraries.values().stream().map(Path::toString), extraPaths.stream().map(Path::toString)).collect(Collectors.joining(File.pathSeparator));
        }

        public String path() {
            return this.path(List.of());
        }

        public Paths paths(Predicate<Library> shouldGoOnClassPath) {
            return this.paths(shouldGoOnClassPath, List.of(), List.of());
        }

        public Paths paths(Predicate<Library> shouldGoOnClassPath, List<Path> extraClassPaths, List<Path> extraModulePaths) {
            return new Paths(Stream.concat(this.libraries.entrySet().stream().filter(entry -> !shouldGoOnClassPath.test((Library)entry.getKey())).map(Map.Entry::getValue).map(Path::toString), extraModulePaths.stream().map(Path::toString)).collect(Collectors.joining(File.pathSeparator)), Stream.concat(this.libraries.entrySet().stream().filter(entry -> shouldGoOnClassPath.test((Library)entry.getKey())).map(Map.Entry::getValue).map(Path::toString), extraClassPaths.stream().map(Path::toString)).collect(Collectors.joining(File.pathSeparator)));
        }

        public ModuleFinder moduleFinder() {
            return ModuleFinder.of((Path[])this.libraries.values().toArray(Path[]::new));
        }

        public record Paths(String modulePath, String classPath) {
            public Paths {
                Objects.requireNonNull(modulePath);
                Objects.requireNonNull(classPath);
            }
        }
    }
}

