/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve;

import dev.mccue.resolve.Cache;
import dev.mccue.resolve.Coordinate;
import dev.mccue.resolve.CoordinateId;
import dev.mccue.resolve.Dependency;
import dev.mccue.resolve.DependencyId;
import dev.mccue.resolve.Exclusions;
import dev.mccue.resolve.Fetch;
import dev.mccue.resolve.InclusionDecision;
import dev.mccue.resolve.Library;
import dev.mccue.resolve.Manifest;
import dev.mccue.resolve.Trace;
import dev.mccue.resolve.VersionMap;
import dev.mccue.resolve.maven.MavenCoordinateId;
import dev.mccue.resolve.util.LL;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public final class Resolve {
    private final LinkedHashMap<Library, Dependency> dependencies = new LinkedHashMap();
    private final LinkedHashMap<Library, Dependency> dependencyOverrides = new LinkedHashMap();
    ExecutorService executorService;
    Cache cache = Cache.standard();

    public Resolve() {
        AtomicInteger count = new AtomicInteger();
        this.executorService = Executors.newFixedThreadPool(8, r -> {
            Thread t = new Thread(r);
            t.setName("resolve-" + count.getAndIncrement());
            t.setDaemon(true);
            return t;
        });
    }

    public Resolve addDependency(Dependency dependency) {
        this.dependencies.put(dependency.library(), dependency);
        return this;
    }

    public Resolve addDependencies(List<Dependency> dependencies) {
        dependencies.forEach(this::addDependency);
        return this;
    }

    public Resolve addDependencyOverride(Dependency dependency) {
        this.dependencyOverrides.put(dependency.library(), dependency);
        return this;
    }

    public Resolve addDependencyOverride(Library library, Dependency dependency) {
        this.dependencyOverrides.put(library, dependency);
        return this;
    }

    public Resolve addDependencyOverrides(List<Dependency> dependencies) {
        dependencies.forEach(this::addDependencyOverride);
        return this;
    }

    public Resolve withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public Resolve withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Result run() {
        return Result.expandDependencies(this.dependencies, this.dependencyOverrides, this.cache, this.executorService);
    }

    public Fetch fetch() {
        return new Fetch(this);
    }

    public static final class Result {
        private final VersionMap versionMap;
        private final Trace trace;

        private Result(VersionMap versionMap, Trace trace) {
            this.versionMap = versionMap;
            this.trace = trace;
        }

        VersionMap versionMap() {
            return this.versionMap;
        }

        static ExclusionsUpdate updateExclusions(Library library, InclusionDecision inclusionDecision, CoordinateId coordinateId, HashMap<DependencyId, Exclusions> cut, Exclusions exclusions) {
            if (inclusionDecision.included()) {
                cut.put(new DependencyId(library, coordinateId), exclusions);
                return new ExclusionsUpdate(exclusions, false);
            }
            if (inclusionDecision == InclusionDecision.SAME_VERSION) {
                DependencyId key = new DependencyId(library, coordinateId);
                Exclusions cutCoord = cut.get(key);
                Exclusions newCut = cutCoord.meet(exclusions);
                cut.put(key, newCut);
                return new ExclusionsUpdate(newCut, !newCut.equals(cutCoord));
            }
            return new ExclusionsUpdate(exclusions, false);
        }

        static Result expandDependencies(Map<Library, Dependency> initialDependencies, Map<Library, Dependency> overrideDependencies, Cache cache, ExecutorService executorService) {
            HashMap<DependencyId, Exclusions> cut = new HashMap<DependencyId, Exclusions>();
            record QueueEntry(Dependency dependency, LL<DependencyId> path, Future<Manifest> manifestPrefetch) {
            }
            ArrayDeque<QueueEntry> q = new ArrayDeque<QueueEntry>();
            initialDependencies.forEach((library, dependency) -> q.add(new QueueEntry(new Dependency((Library)library, dependency.coordinate(), dependency.exclusions()), new LL.Nil<DependencyId>(), executorService.submit(() -> dependency.coordinate().getManifest(cache)))));
            VersionMap versionMap = new VersionMap();
            Trace trace = new Trace();
            while (!q.isEmpty()) {
                Manifest coordinateManifest;
                QueueEntry queueEntry = (QueueEntry)q.poll();
                Library library2 = queueEntry.dependency.library();
                Dependency dependency2 = overrideDependencies.getOrDefault(library2, queueEntry.dependency);
                Coordinate coordinate = dependency2.coordinate();
                CoordinateId coordinateId = coordinate.id();
                InclusionDecision decision = versionMap.includeCoordinate(dependency2, coordinateId, queueEntry.path);
                trace.add(new Trace.Entry(queueEntry.path.reverse().toJavaList(), dependency2.library(), dependency2.coordinate().id(), decision));
                ExclusionsUpdate exclusionsUpdate = Result.updateExclusions(library2, decision, coordinateId, cut, dependency2.exclusions());
                Exclusions exclusions = exclusionsUpdate.newExclusions;
                if (!decision.included() && !exclusionsUpdate.wasUpdated) continue;
                try {
                    coordinateManifest = queueEntry.manifestPrefetch.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                List<Dependency> afterExclusions = coordinateManifest.dependencies().stream().filter(dep -> exclusions.shouldInclude(dep.library())).map(dep -> dep.withExclusions(dep.exclusions().join(exclusions))).toList();
                for (Dependency manifestDep : afterExclusions) {
                    q.add(new QueueEntry(manifestDep, queueEntry.path.prepend(new DependencyId(queueEntry.dependency)), executorService.submit(() -> manifestDep.coordinate().getManifest(cache))));
                }
            }
            return new Result(versionMap, trace);
        }

        public List<Dependency> selectedDependencies() {
            return this.versionMap.selectedDependencies();
        }

        public void printTree(PrintWriter out, List<Library> hideLibraries) {
            HashMap keyedEntries = new HashMap();
            for (Trace.Entry entry2 : this.trace) {
                keyedEntries.put(entry2.path(), keyedEntries.getOrDefault(entry2.path(), new ArrayList()));
                ((ArrayList)keyedEntries.get(entry2.path())).add(entry2);
            }
            List<Trace.Entry> roots = this.trace.stream().filter(entry -> entry.path().isEmpty()).sorted(Comparator.comparing(entry -> entry.library().group()).thenComparing(entry -> entry.library().artifact())).toList();
            ArrayDeque<Trace.Entry> q = new ArrayDeque<Trace.Entry>(roots);
            while (!q.isEmpty()) {
                boolean superseded;
                Trace.Entry entry3 = q.pollFirst();
                int depth = entry3.path().size();
                if (entry3.inclusionDecision() != InclusionDecision.NEW_TOP_DEP && hideLibraries.contains(entry3.library())) continue;
                boolean bl = superseded = Set.of(InclusionDecision.SAME_VERSION, InclusionDecision.NEW_DEP).contains((Object)entry3.inclusionDecision()) && !this.versionMap.selectedVersion(entry3.library()).equals(Optional.of(entry3.coordinateId()));
                if (depth != 0) {
                    out.print("  ".repeat(depth));
                    if (!entry3.inclusionDecision().included() && !Set.of(InclusionDecision.SAME_VERSION, InclusionDecision.NEW_DEP).contains((Object)entry3.inclusionDecision())) {
                        out.print("X ");
                    } else if (superseded) {
                        out.print("X ");
                    } else {
                        out.print(". ");
                    }
                }
                out.print(entry3.library().group().value());
                out.print("/");
                out.print(entry3.library().artifact().value());
                out.print(" ");
                CoordinateId coordinateId = entry3.coordinateId();
                if (coordinateId instanceof MavenCoordinateId) {
                    MavenCoordinateId mavenCoordinateId = (MavenCoordinateId)coordinateId;
                    out.print(mavenCoordinateId.version());
                } else {
                    out.print(entry3.coordinateId());
                }
                if (!entry3.inclusionDecision().included() && !Set.of(InclusionDecision.SAME_VERSION, InclusionDecision.NEW_DEP).contains((Object)entry3.inclusionDecision())) {
                    out.print(" " + String.valueOf((Object)entry3.inclusionDecision()));
                } else if (superseded) {
                    out.print(" SUPERSEDED");
                }
                out.println();
                ArrayList<DependencyId> nextPath = new ArrayList<DependencyId>(entry3.path());
                nextPath.add(new DependencyId(entry3.library(), entry3.coordinateId()));
                ArrayList next = (ArrayList)keyedEntries.get(nextPath);
                if (next == null) continue;
                for (int i = next.size() - 1; i >= 0; --i) {
                    q.addFirst((Trace.Entry)next.get(i));
                }
            }
        }

        public void printTree(PrintStream out, List<Library> hideLibraries) {
            PrintWriter writer = new PrintWriter(out);
            this.printTree(writer, hideLibraries);
            writer.flush();
        }

        public void printTree(PrintStream out) {
            this.printTree(out, List.of());
        }

        public void printTree(PrintWriter out) {
            this.printTree(out, List.of());
        }

        public void printTree() {
            this.printTree(System.out, List.of());
        }

        public void printTree(List<Library> hideLibraries) {
            this.printTree(System.out, hideLibraries);
        }

        public Fetch fetch() {
            return new Fetch(this);
        }

        record ExclusionsUpdate(Exclusions newExclusions, boolean wasUpdated) {
        }
    }
}

