/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve;

import dev.mccue.resolve.Cache;
import dev.mccue.resolve.CacheKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class StandardCache
implements Cache {
    private static final System.Logger LOG = System.getLogger(StandardCache.class.getName());
    private static final ConcurrentHashMap<String, String> INTERNED_STRINGS = new ConcurrentHashMap();
    private final Path root;

    private static Object lockFor(Path cachePath) {
        String key = "jresolve-jvm-lock-" + cachePath.toString();
        String lock0 = INTERNED_STRINGS.get(key);
        if (lock0 == null) {
            String internedKey = key.intern();
            INTERNED_STRINGS.putIfAbsent(internedKey, internedKey);
            lock0 = internedKey;
        }
        return lock0;
    }

    public StandardCache(Path root) {
        Objects.requireNonNull(root);
        this.root = root;
    }

    public StandardCache() {
        this(Path.of(System.getProperty("user.home"), ".jresolve", "cache"));
    }

    private Path keyPath(CacheKey key) {
        return Path.of(this.root.toString(), (String[])key.components().toArray(String[]::new));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof StandardCache)) return false;
        StandardCache standardCache = (StandardCache)obj;
        if (!this.root.equals(standardCache.root)) return false;
        return true;
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        return "StandardCache[root=" + String.valueOf(this.root) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path fetchIfAbsent(CacheKey key, Supplier<InputStream> data) {
        Path filePath = this.keyPath(key);
        Object object = StandardCache.lockFor(filePath);
        synchronized (object) {
            boolean noFile;
            LOG.log(System.Logger.Level.TRACE, () -> "About to check if file exists. filePath=" + String.valueOf(filePath));
            boolean bl = noFile = !Files.exists(filePath, new LinkOption[0]);
            if (noFile) {
                LOG.log(System.Logger.Level.TRACE, () -> "File does not exist. filePath=" + String.valueOf(filePath));
                try {
                    LOG.log(System.Logger.Level.TRACE, () -> "Acquiring structural lock. root=" + String.valueOf(this.root));
                    StandardCache.withStructureLock(this.root, () -> {
                        try {
                            LOG.log(System.Logger.Level.TRACE, () -> "Creating parent directories for file. filePath=" + String.valueOf(filePath));
                            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                    LOG.log(System.Logger.Level.TRACE, () -> "Released structural lock. root=" + String.valueOf(this.root));
                    LOG.log(System.Logger.Level.TRACE, () -> "About to get data from input source. data=" + String.valueOf(data));
                    try (InputStream inputStream = data.get();){
                        Path path;
                        block20: {
                            OutputStream outputStream = Files.newOutputStream(filePath, StandardOpenOption.CREATE_NEW);
                            try {
                                LOG.log(System.Logger.Level.TRACE, () -> "Transferring contents to file. filePath=" + String.valueOf(filePath));
                                inputStream.transferTo(outputStream);
                                path = filePath;
                                if (outputStream == null) break block20;
                            }
                            catch (Throwable throwable) {
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            outputStream.close();
                        }
                        return path;
                    }
                    catch (FileAlreadyExistsException e) {
                        LOG.log(System.Logger.Level.TRACE, () -> "File already exists in cache. filePath=" + String.valueOf(filePath));
                        return filePath;
                    }
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.TRACE, () -> "Error getting data. filePath=" + String.valueOf(filePath), (Throwable)e);
                    throw new UncheckedIOException(e);
                }
            }
            LOG.log(System.Logger.Level.TRACE, () -> "File exists. filePath=" + String.valueOf(filePath));
            return filePath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void withStructureLock(Path cache, Runnable runnable) {
        try {
            Object object = StandardCache.lockFor(cache);
            synchronized (object) {
                Path lockFile = cache.resolve(".structure.lock");
                Files.createDirectories(lockFile.getParent(), new FileAttribute[0]);
                try (FileChannel channel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);){
                    FileLock lock = null;
                    try {
                        lock = channel.lock();
                        try {
                            runnable.run();
                        }
                        finally {
                            lock.release();
                            lock = null;
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path fetch(CacheKey key, Supplier<InputStream> data) {
        Path filePath = this.keyPath(key);
        Object object = StandardCache.lockFor(filePath);
        synchronized (object) {
            boolean noFile;
            LOG.log(System.Logger.Level.TRACE, () -> "About to check if file exists. filePath=" + String.valueOf(filePath));
            boolean bl = noFile = !Files.exists(filePath, new LinkOption[0]);
            if (noFile) {
                LOG.log(System.Logger.Level.TRACE, () -> "File does not exist. filePath=" + String.valueOf(filePath));
                LOG.log(System.Logger.Level.TRACE, () -> "Acquiring structural lock. root=" + String.valueOf(this.root));
                StandardCache.withStructureLock(this.root, () -> {
                    try {
                        LOG.log(System.Logger.Level.TRACE, () -> "Creating parent directories for file. filePath=" + String.valueOf(filePath));
                        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                LOG.log(System.Logger.Level.TRACE, () -> "Released structural lock. root=" + String.valueOf(this.root));
            } else {
                LOG.log(System.Logger.Level.TRACE, () -> "File exists. filePath=" + String.valueOf(filePath));
            }
            LOG.log(System.Logger.Level.TRACE, () -> "About to get data from input source. data=" + String.valueOf(data));
            try (InputStream inputStream = data.get();){
                Path path;
                block19: {
                    OutputStream outputStream = Files.newOutputStream(filePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    try {
                        LOG.log(System.Logger.Level.TRACE, () -> "Transferring contents to file. filePath=" + String.valueOf(filePath));
                        inputStream.transferTo(outputStream);
                        path = filePath;
                        if (outputStream == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    outputStream.close();
                }
                return path;
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.TRACE, () -> "Error getting data. filePath=" + String.valueOf(filePath), (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public boolean probablyContains(CacheKey key) {
        Path filePath = this.keyPath(key);
        return Files.exists(filePath, new LinkOption[0]);
    }
}

