/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve;

import dev.mccue.resolve.doc.Maven;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@Maven(value="https://github.com/apache/maven-resolver/blob/97dfd1c/maven-resolver-util/src/main/java/org/eclipse/aether/util/version/GenericVersion.java")
public final class Version
implements Comparable<Version> {
    private final String version;
    private final List<Item> items;
    private final int hash;

    public Version(String version) {
        this.version = Objects.requireNonNull(version, "version cannot be null");
        this.items = Version.parse(version);
        this.hash = this.items.hashCode();
    }

    private static List<Item> parse(String version) {
        ArrayList<Item> items = new ArrayList<Item>();
        Tokenizer tokenizer = new Tokenizer(version);
        while (tokenizer.next()) {
            Item item = tokenizer.toItem();
            items.add(item);
        }
        Version.trimPadding(items);
        return Collections.unmodifiableList(items);
    }

    private static void trimPadding(List<Item> items) {
        int end;
        Boolean number = null;
        for (int i = end = items.size() - 1; i > 0; --i) {
            Item item = items.get(i);
            if (!Boolean.valueOf(item.isNumber()).equals(number)) {
                end = i;
                number = item.isNumber();
            }
            if (end != i || i != items.size() - 1 && items.get(i - 1).isNumber() != item.isNumber() || item.compareTo(null) != 0) continue;
            items.remove(i);
            --end;
        }
    }

    private static int comparePadding(List<Item> items, int index, Boolean number) {
        int rel = 0;
        for (int i = index; i < items.size(); ++i) {
            Item item = items.get(i);
            if ((number == null || number.booleanValue() == item.isNumber()) && (rel = item.compareTo(null)) != 0) break;
        }
        return rel;
    }

    @Override
    public int compareTo(Version obj) {
        List<Item> these = this.items;
        List<Item> those = obj.items;
        boolean number = true;
        int index = 0;
        while (index < these.size() || index < those.size()) {
            if (index >= these.size()) {
                return -Version.comparePadding(those, index, null);
            }
            if (index >= those.size()) {
                return Version.comparePadding(these, index, null);
            }
            Item thisItem = these.get(index);
            Item thatItem = those.get(index);
            if (thisItem.isNumber() != thatItem.isNumber()) {
                if (number == thisItem.isNumber()) {
                    return Version.comparePadding(these, index, number);
                }
                return -Version.comparePadding(those, index, number);
            }
            int rel = thisItem.compareTo(thatItem);
            if (rel != 0) {
                return rel;
            }
            number = thisItem.isNumber();
            ++index;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        Version other;
        return obj instanceof Version && this.compareTo(other = (Version)obj) == 0;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.version;
    }

    private static final class Tokenizer {
        private static final Integer QUALIFIER_ALPHA = -5;
        private static final Integer QUALIFIER_BETA = -4;
        private static final Integer QUALIFIER_MILESTONE = -3;
        private static final Map<String, Integer> QUALIFIERS = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private final String version;
        private final int versionLength;
        private int index;
        private String token;
        private boolean number;
        private boolean terminatedByNumber;

        Tokenizer(String version) {
            this.version = version.length() > 0 ? version : "0";
            this.versionLength = this.version.length();
        }

        public boolean next() {
            if (this.index >= this.versionLength) {
                return false;
            }
            int state = -2;
            int start = this.index;
            int end = this.versionLength;
            this.terminatedByNumber = false;
            while (this.index < this.versionLength) {
                char c = this.version.charAt(this.index);
                if (c == '.' || c == '-' || c == '_') {
                    end = this.index++;
                    break;
                }
                int digit = Character.digit(c, 10);
                if (digit >= 0) {
                    if (state == -1) {
                        end = this.index;
                        this.terminatedByNumber = true;
                        break;
                    }
                    if (state == 0) {
                        ++start;
                    }
                    state = state > 0 || digit > 0 ? 1 : 0;
                } else {
                    if (state >= 0) {
                        end = this.index;
                        break;
                    }
                    state = -1;
                }
                ++this.index;
            }
            if (end - start > 0) {
                this.token = this.version.substring(start, end);
                this.number = state >= 0;
            } else {
                this.token = "0";
                this.number = true;
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.token);
        }

        public Item toItem() {
            Integer qualifier;
            if (this.number) {
                try {
                    if (this.token.length() < 10) {
                        return new Item(Item.Kind.INT, Integer.parseInt(this.token));
                    }
                    return new Item(Item.Kind.BIGINT, new BigInteger(this.token));
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (this.index >= this.version.length()) {
                if ("min".equalsIgnoreCase(this.token)) {
                    return Item.MIN;
                }
                if ("max".equalsIgnoreCase(this.token)) {
                    return Item.MAX;
                }
            }
            if (this.terminatedByNumber && this.token.length() == 1) {
                switch (this.token.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        return new Item(Item.Kind.QUALIFIER, QUALIFIER_ALPHA);
                    }
                    case 'B': 
                    case 'b': {
                        return new Item(Item.Kind.QUALIFIER, QUALIFIER_BETA);
                    }
                    case 'M': 
                    case 'm': {
                        return new Item(Item.Kind.QUALIFIER, QUALIFIER_MILESTONE);
                    }
                }
            }
            if ((qualifier = QUALIFIERS.get(this.token)) != null) {
                return new Item(Item.Kind.QUALIFIER, qualifier);
            }
            return new Item(Item.Kind.STRING, this.token.toLowerCase(Locale.ENGLISH));
        }

        static {
            QUALIFIERS.put("alpha", QUALIFIER_ALPHA);
            QUALIFIERS.put("beta", QUALIFIER_BETA);
            QUALIFIERS.put("milestone", QUALIFIER_MILESTONE);
            QUALIFIERS.put("cr", -2);
            QUALIFIERS.put("rc", -2);
            QUALIFIERS.put("snapshot", -1);
            QUALIFIERS.put("ga", 0);
            QUALIFIERS.put("final", 0);
            QUALIFIERS.put("release", 0);
            QUALIFIERS.put("", 0);
            QUALIFIERS.put("sp", 1);
        }
    }

    private record Item(Kind kind, Object value) {
        static final Item MAX = new Item(Kind.MAX, "max");
        static final Item MIN = new Item(Kind.MIN, "min");

        public boolean isNumber() {
            return (this.kind.value & Kind.QUALIFIER.value) == 0;
        }

        public int compareTo(Item that) {
            int rel;
            if (that == null) {
                rel = switch (this.kind.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 5 -> -1;
                    case 0, 1, 3 -> 1;
                    case 2, 4 -> (Integer)this.value;
                };
            } else {
                rel = this.kind.value - that.kind.value;
                if (rel == 0) {
                    switch (this.kind.ordinal()) {
                        case 1: {
                            rel = ((BigInteger)this.value).compareTo((BigInteger)that.value);
                            break;
                        }
                        case 2: 
                        case 4: {
                            rel = ((Integer)this.value).compareTo((Integer)that.value);
                            break;
                        }
                        case 3: {
                            rel = ((String)this.value).compareToIgnoreCase((String)that.value);
                        }
                    }
                }
            }
            return rel;
        }

        @Override
        public boolean equals(Object obj) {
            Item item;
            return obj instanceof Item && this.compareTo(item = (Item)obj) == 0;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }

        static enum Kind {
            MAX(8),
            BIGINT(5),
            INT(4),
            STRING(3),
            QUALIFIER(2),
            MIN(0);

            final int value;

            private Kind(int value) {
                this.value = value;
            }
        }
    }
}

