/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve;

import dev.mccue.resolve.Coordinate;
import dev.mccue.resolve.CoordinateId;
import dev.mccue.resolve.Dependency;
import dev.mccue.resolve.DependencyId;
import dev.mccue.resolve.InclusionDecision;
import dev.mccue.resolve.Library;
import dev.mccue.resolve.util.LL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class VersionMap {
    private final LinkedHashMap<Library, Entry> value = new LinkedHashMap();

    public void addVersion(Library library, Coordinate coordinate, LL<DependencyId> dependencyPath, CoordinateId coordinateId) {
        Entry entry = this.value.getOrDefault(library, new Entry());
        entry.versions.put(coordinateId, coordinate);
        entry.paths.computeIfAbsent(coordinateId, k -> new HashSet());
        entry.paths.get(coordinateId).add(dependencyPath);
        this.value.put(library, entry);
    }

    public void selectVersion(Library library, CoordinateId coordinateId, boolean isTop) {
        Entry entry = this.value.computeIfAbsent(library, __ -> new Entry());
        entry = entry.withSelection(coordinateId);
        if (isTop) {
            entry = entry.asTopDep();
        }
        this.value.put(library, entry);
    }

    public Optional<CoordinateId> selectedVersion(Library library) {
        Entry entry = this.value.get(library);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(entry.currentSelection);
    }

    public Optional<Coordinate> selectedDep(Library library) {
        return this.selectedVersion(library).map(this.value.get((Object)library).versions::get);
    }

    public Map<Library, CoordinateId> selectedCoordinateIds() {
        return this.value.entrySet().stream().filter(entry -> ((Entry)entry.getValue()).currentSelection != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Entry)entry.getValue()).currentSelection));
    }

    public List<Dependency> selectedDependencies() {
        return this.value.entrySet().stream().filter(entry -> ((Entry)entry.getValue()).currentSelection != null).map(entry -> new Dependency((Library)entry.getKey(), ((Entry)entry.getValue()).versions.get(((Entry)entry.getValue()).currentSelection))).toList();
    }

    public Optional<List<LL<DependencyId>>> selectedPaths(Library library) {
        Entry entry = this.value.get(library);
        if (entry == null) {
            return Optional.empty();
        }
        CoordinateId selectedVersion = this.selectedVersion(library).orElse(null);
        if (selectedVersion == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(List.copyOf((Collection)entry.paths.get(selectedVersion)));
    }

    public boolean parentMissing(LL<DependencyId> parentDependencyPath) {
        if (parentDependencyPath.isEmpty()) {
            return false;
        }
        LL<DependencyId> path = parentDependencyPath;
        while (path instanceof LL.Cons) {
            LL.Cons consPath = (LL.Cons)path;
            DependencyId dependencyId = (DependencyId)consPath.head();
            LL checkPath = consPath.tail();
            Entry vmapEntry = this.value.get(dependencyId.library());
            if (vmapEntry != null && vmapEntry.paths().getOrDefault(vmapEntry.currentSelection, new HashSet()).contains(checkPath)) {
                path = checkPath;
                continue;
            }
            return true;
        }
        return false;
    }

    public void deselectOrphans(List<LL<DependencyId>> omittedDependencyPaths) {
        ArrayList<Map.Entry> toPut = new ArrayList<Map.Entry>();
        for (Map.Entry<Library, Entry> kv2 : this.value.entrySet()) {
            Library library = kv2.getKey();
            Entry entry = kv2.getValue();
            List allPaths = this.selectedPaths(library).orElse(List.of());
            boolean deselect = allPaths.stream().allMatch(path -> omittedDependencyPaths.stream().anyMatch(omittedPath -> omittedPath.isSuffix(path)));
            if (!deselect) continue;
            Entry newEntry = entry.withSelection(null);
            toPut.add(Map.entry(library, newEntry));
        }
        toPut.forEach(kv -> this.value.put((Library)kv.getKey(), (Entry)kv.getValue()));
    }

    public InclusionDecision includeCoordinate(Dependency dependency, CoordinateId coordinateId, LL<DependencyId> dependencyPath) {
        Library library = dependency.library();
        Coordinate coordinate = dependency.coordinate();
        if (dependencyPath.isEmpty()) {
            this.addVersion(library, coordinate, dependencyPath, coordinateId);
            this.selectVersion(library, coordinateId, true);
            return InclusionDecision.NEW_TOP_DEP;
        }
        if (!dependency.exclusions().shouldInclude(library)) {
            return InclusionDecision.EXCLUDED;
        }
        if (this.value.get(library) != null && this.value.get(library).topDep()) {
            return InclusionDecision.USE_TOP;
        }
        if (this.parentMissing(dependencyPath)) {
            return InclusionDecision.PARENT_OMITTED;
        }
        if (this.selectedVersion(library).isEmpty()) {
            this.addVersion(library, coordinate, dependencyPath, coordinateId);
            this.selectVersion(library, coordinateId, false);
            return InclusionDecision.NEW_DEP;
        }
        if (Objects.equals(this.selectedVersion(library).orElse(null), coordinateId)) {
            this.addVersion(library, coordinate, dependencyPath, coordinateId);
            return InclusionDecision.SAME_VERSION;
        }
        Coordinate selectedDep = this.selectedDep(library).orElseThrow();
        Objects.requireNonNull(selectedDep, "selectedVersion");
        Coordinate.VersionOrdering comparison = coordinate.compareVersions(selectedDep);
        if (comparison == Coordinate.VersionOrdering.INCOMPARABLE) {
            throw new RuntimeException("Incomparable coordinates: " + String.valueOf(coordinate.getClass()) + ", " + String.valueOf(selectedDep.getClass()));
        }
        if (comparison == Coordinate.VersionOrdering.GREATER_THAN) {
            this.addVersion(library, coordinate, dependencyPath, coordinateId);
            List<LL<DependencyId>> paths = this.selectedPaths(library).orElseThrow().stream().map(path -> path.prepend(new DependencyId(library, this.selectedVersion(library).orElseThrow()))).toList();
            this.deselectOrphans(paths);
            this.selectVersion(library, coordinateId, false);
            return InclusionDecision.NEWER_VERSION;
        }
        return InclusionDecision.OLDER_VERSION;
    }

    public String toString() {
        return this.value.toString();
    }

    public void printPrettyString() {
        this.value.forEach((library, entry) -> {
            System.out.println(library);
            System.out.println("-".repeat(40));
            System.out.print(" ".repeat(4));
            System.out.println("TOP_DEP");
            System.out.print(" ".repeat(8));
            System.out.println(entry.topDep);
            System.out.print(" ".repeat(4));
            System.out.println("CURRENT_SELECTION");
            System.out.print(" ".repeat(8));
            System.out.println(entry.currentSelection);
            System.out.print(" ".repeat(4));
            System.out.println("VERSIONS");
            entry.versions.forEach((coordinateId, coordinate) -> {
                System.out.print(" ".repeat(8));
                System.out.print(coordinateId);
                System.out.print("  ->  ");
                System.out.println(coordinate);
            });
            System.out.print(" ".repeat(4));
            System.out.println("PATHS");
            entry.paths.forEach((coordinateId, dependencyPaths) -> {
                System.out.print(" ".repeat(8));
                System.out.println(coordinateId);
                dependencyPaths.forEach(path -> {
                    System.out.print(" ".repeat(12));
                    System.out.println(path);
                });
            });
            System.out.println();
        });
    }

    public record Entry(LinkedHashMap<CoordinateId, Coordinate> versions, LinkedHashMap<CoordinateId, HashSet<LL<DependencyId>>> paths, CoordinateId currentSelection, boolean topDep) {
        public Entry() {
            this(new LinkedHashMap<CoordinateId, Coordinate>(), new LinkedHashMap<CoordinateId, HashSet<LL<DependencyId>>>(), null, false);
        }

        public Entry(LinkedHashMap<CoordinateId, Coordinate> versions, LinkedHashMap<CoordinateId, HashSet<LL<DependencyId>>> paths) {
            this(versions, paths, null, false);
        }

        Entry asTopDep() {
            return new Entry(this.versions, this.paths, this.currentSelection, true);
        }

        Entry withSelection(CoordinateId selection) {
            return new Entry(this.versions, this.paths, selection, this.topDep);
        }
    }
}

