/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Variant;
import java.util.Objects;
import java.util.function.Function;

public record Classifier(String value) implements Comparable<Classifier>
{
    public static final Classifier EMPTY = new Classifier("");
    public static final Classifier TESTS = new Classifier("tests");
    public static final Classifier JAVADOC = new Classifier("javadoc");
    public static final Classifier SOURCES = new Classifier("sources");

    public Classifier {
        Objects.requireNonNull(value, "value must not be null");
    }

    @Override
    public int compareTo(Classifier o) {
        return this.value.compareTo(o.value);
    }

    public Classifier map(Function<String, String> f) {
        return new Classifier(f.apply(this.value));
    }

    public Variant asVariant() {
        return this == EMPTY ? Variant.DEFAULT : new Variant(this.value);
    }

    @Override
    public String toString() {
        if (this.equals(EMPTY)) {
            return "Classifier[EMPTY]";
        }
        return "Classifier[value='" + this.value + "']";
    }
}

