/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Cache;
import dev.mccue.resolve.maven.ChildHavingPomInfo;
import dev.mccue.resolve.maven.MavenRepository;
import dev.mccue.resolve.maven.Os;
import dev.mccue.resolve.maven.PomArtifactId;
import dev.mccue.resolve.maven.PomClassifier;
import dev.mccue.resolve.maven.PomDependency;
import dev.mccue.resolve.maven.PomGroupId;
import dev.mccue.resolve.maven.PomPackaging;
import dev.mccue.resolve.maven.PomProperty;
import dev.mccue.resolve.maven.PomType;
import dev.mccue.resolve.maven.PomVersion;
import dev.mccue.resolve.maven.Scope;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;

@NullMarked
record EffectivePomInfo(PomGroupId groupId, PomArtifactId artifactId, PomVersion version, List<PomDependency> dependencies, List<PomDependency> dependencyManagement, PomPackaging packaging, Map<String, String> properties) {
    private static final Pattern MAVEN_PROPERTY = Pattern.compile("\\$\\{([^<>{}]+)}");

    static EffectivePomInfo from(ChildHavingPomInfo childHavingPomInfo, Runtime.Version jdkVersion, Os os) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        ChildHavingPomInfo top = childHavingPomInfo;
        while (top != null) {
            for (PomProperty property : top.properties()) {
                properties.put(property.key(), property.value());
            }
            top = top.child().orElse(null);
        }
        properties.put("java.version", jdkVersion.toString());
        properties.put("os.name", os.name());
        properties.put("os.arch", os.arch());
        properties.put("os.version", os.version());
        Function<String, String> resolve = str -> EffectivePomInfo.resolveProperties(properties, str);
        Function<PomDependency, PomDependency> resolveDep = dependency -> dependency.map(resolve);
        PomGroupId groupId = PomGroupId.Undeclared.INSTANCE;
        PomVersion version = PomVersion.Undeclared.INSTANCE;
        PomPackaging packaging = PomPackaging.Undeclared.INSTANCE;
        LinkedHashMap dependencies = new LinkedHashMap();
        LinkedHashMap dependencyManagement = new LinkedHashMap();
        top = childHavingPomInfo;
        while (top != null) {
            if (top.groupId() instanceof PomGroupId.Declared) {
                groupId = top.groupId().map(resolve);
            }
            if (top.version() instanceof PomVersion.Declared) {
                version = top.version().map(resolve);
            }
            if (top.packaging() instanceof PomPackaging.Declared) {
                packaging = top.packaging().map(resolve);
            }
            top = top.child().orElse(null);
        }
        groupId.ifDeclared(value -> properties.put("project.groupId", (String)value));
        version.ifDeclared(value -> properties.put("project.version", (String)value));
        PomArtifactId artifactId = childHavingPomInfo.artifactId().map(resolve);
        artifactId.ifDeclared(value -> properties.put("project.artifactId", (String)value));
        top = childHavingPomInfo;
        while (top != null) {
            top.dependencies().forEach(dependency -> {
                PomDependency newDep = (PomDependency)resolveDep.apply((PomDependency)dependency);
                dependencies.put(PomDependencyKey.from(newDep), newDep);
            });
            top.dependencyManagement().forEach(dependency -> {
                PomDependency newDep = (PomDependency)resolveDep.apply((PomDependency)dependency);
                dependencyManagement.put(PomDependencyKey.from(newDep), newDep);
            });
            top = top.child().orElse(null);
        }
        return new EffectivePomInfo(groupId, artifactId, version, List.copyOf(dependencies.values()), List.copyOf(dependencyManagement.values()), packaging, properties);
    }

    EffectivePomInfo resolveImports(MavenRepository repository, Cache cache, Runtime.Version jdkVersion, Os os) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(this.properties);
        List dependencyManagementWithImportsFlattened = this.dependencyManagement.stream().mapMulti((dependency, addDep) -> {
            if (!dependency.scope().orElse(Scope.COMPILE).equals(Scope.IMPORT)) {
                addDep.accept(dependency);
            } else {
                dependency = dependency.map(s -> EffectivePomInfo.resolveProperties(props, s));
                EffectivePomInfo effectiveBom = EffectivePomInfo.from(repository.getAllPoms(dependency.groupId().orElseThrow(), dependency.artifactId().orElseThrow(), dependency.version().orElseThrow(), cache), jdkVersion, os).resolveImports(repository, cache, jdkVersion, os);
                effectiveBom.properties.forEach((k, v) -> {
                    if (!props.containsKey(k)) {
                        props.put((String)k, (String)v);
                    }
                });
                effectiveBom.dependencyManagement.forEach(addDep);
            }
        }).toList();
        return new EffectivePomInfo(this.groupId, this.artifactId, this.version, this.dependencies.stream().map(dep -> dep.map(s -> EffectivePomInfo.resolveProperties(props, s))).toList(), dependencyManagementWithImportsFlattened.stream().map(dep -> dep.map(s -> EffectivePomInfo.resolveProperties(props, s))).toList(), this.packaging, props);
    }

    static String resolveProperties(Map<String, String> properties, String data) {
        if (data == null) {
            return null;
        }
        StringBuilder processed_data = new StringBuilder();
        Matcher matcher = MAVEN_PROPERTY.matcher(data);
        int last_end = 0;
        while (matcher.find()) {
            String property;
            if (matcher.groupCount() != 1 || !properties.containsKey(property = matcher.group(1))) continue;
            processed_data.append(data, last_end, matcher.start());
            processed_data.append(properties.get(property));
            last_end = matcher.end();
        }
        if (last_end < data.length()) {
            processed_data.append(data.substring(last_end));
        }
        return processed_data.toString();
    }

    private record PomDependencyKey(PomGroupId groupId, PomArtifactId artifactId, PomVersion version, PomClassifier classifier, PomType type) {
        static PomDependencyKey from(PomDependency pomDependency) {
            return new PomDependencyKey(pomDependency.groupId(), pomDependency.artifactId(), pomDependency.version(), pomDependency.classifier(), pomDependency.type());
        }
    }
}

