/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.maven.Transport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;

public final class FileTransport
implements Transport {
    private final Path root;

    public FileTransport(Path root) {
        this.root = root;
    }

    @Override
    public List<String> cachePrefix() {
        return List.copyOf(Arrays.asList(this.root.toString().split(File.pathSeparator)));
    }

    @Override
    public Transport.GetFileResult getFile(List<String> pathElements) {
        try {
            return new Transport.GetFileResult.Success(Files.newInputStream(Path.of(this.root.toString(), (String[])pathElements.toArray(String[]::new)), new OpenOption[0]), OptionalLong.empty());
        }
        catch (NoSuchFileException e) {
            return new Transport.GetFileResult.NotFound();
        }
        catch (IOException e) {
            return new Transport.GetFileResult.Error(e);
        }
    }
}

