/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.maven.Transport;
import dev.mccue.resolve.util.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class HttpTransport
implements Transport {
    private static final System.Logger LOG = System.getLogger(HttpTransport.class.getName());
    private final String url;
    private final Lazy<HttpClient> httpClient;
    private final Consumer<HttpRequest.Builder> enrichRequest;

    public HttpTransport(String url, Supplier<HttpClient> httpClient, Consumer<HttpRequest.Builder> enrichRequest) {
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.url = url;
        this.httpClient = new Lazy<HttpClient>(httpClient);
        this.enrichRequest = enrichRequest;
    }

    @Override
    public List<String> cachePrefix() {
        String url = this.url;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return List.copyOf(Arrays.asList(url.split("((:)*/)+")));
    }

    @Override
    public Transport.GetFileResult getFile(List<String> pathElements) {
        String path = this.url + String.join((CharSequence)"/", pathElements);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().uri(URI.create(path));
        this.enrichRequest.accept(requestBuilder);
        HttpClient httpClient = this.httpClient.get();
        LOG.log(System.Logger.Level.TRACE, () -> "About to download file. path=" + path + ", transport=" + String.valueOf(this));
        try {
            HttpResponse<InputStream> response = httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            LOG.log(System.Logger.Level.TRACE, () -> "Got response for file. statusCode=" + response.statusCode() + ", path=" + path + ", transport=" + String.valueOf(this));
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                if (response.statusCode() == 404) {
                    return new Transport.GetFileResult.NotFound();
                }
                return new Transport.GetFileResult.Error(new IOException("Bad status code: statusCode=" + response.statusCode()));
            }
            OptionalLong[] sizeHint = new OptionalLong[]{OptionalLong.empty()};
            response.headers().firstValue("content-length").map(contentLengthString -> {
                try {
                    return Long.parseLong(contentLengthString);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).ifPresent(contentLength -> {
                sizeHint[0] = OptionalLong.of(contentLength);
            });
            return new Transport.GetFileResult.Success(response.body(), sizeHint[0]);
        }
        catch (IOException | InterruptedException e) {
            return new Transport.GetFileResult.Error(e);
        }
    }

    public String toString() {
        return "HttpTransport[" + this.url + "]";
    }
}

