/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Artifact;
import dev.mccue.resolve.Cache;
import dev.mccue.resolve.CacheKey;
import dev.mccue.resolve.Coordinate;
import dev.mccue.resolve.CoordinateId;
import dev.mccue.resolve.Group;
import dev.mccue.resolve.Manifest;
import dev.mccue.resolve.Version;
import dev.mccue.resolve.maven.ArtifactNotFound;
import dev.mccue.resolve.maven.Classifier;
import dev.mccue.resolve.maven.Extension;
import dev.mccue.resolve.maven.MavenCoordinateId;
import dev.mccue.resolve.maven.MavenRepository;
import dev.mccue.resolve.maven.Os;
import dev.mccue.resolve.maven.Scope;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public record MavenCoordinate(Group group, Artifact artifact, Version version, List<MavenRepository> repositories, List<Scope> scopes, Classifier classifier, Classifier sourceClassifier, Classifier documentationClassifier, Runtime.Version jdkVersion, Os os) implements Coordinate
{
    private static final System.Logger LOG = System.getLogger(MavenCoordinate.class.getName());

    public MavenCoordinate(Group group, Artifact artifact, Version version, List<MavenRepository> repositories, List<Scope> scopes, Classifier classifier, Classifier sourceClassifier, Classifier documentationClassifier, Runtime.Version jdkVersion, Os os) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.repositories = List.copyOf(repositories);
        this.scopes = List.copyOf(scopes);
        this.classifier = classifier;
        this.sourceClassifier = sourceClassifier;
        this.documentationClassifier = documentationClassifier;
        this.jdkVersion = jdkVersion;
        this.os = os;
    }

    public MavenCoordinate(Group group, Artifact artifact, Version version, List<MavenRepository> repositories, List<Scope> scopes) {
        this(group, artifact, version, repositories, scopes, Classifier.EMPTY, Classifier.SOURCES, Classifier.JAVADOC);
    }

    public MavenCoordinate(Group group, Artifact artifact, Version version, List<MavenRepository> repositories, List<Scope> scopes, Classifier classifier, Classifier sourceClassifier, Classifier documentationClassifier) {
        this(group, artifact, version, repositories, scopes, classifier, sourceClassifier, documentationClassifier, Runtime.version(), new Os());
    }

    public MavenCoordinate(Group group, Artifact artifact, Version version, List<MavenRepository> repositories) {
        this(group, artifact, version, repositories, List.of(Scope.COMPILE, Scope.RUNTIME));
    }

    @Override
    public Coordinate.VersionOrdering compareVersions(Coordinate coordinate) {
        if (!(coordinate instanceof MavenCoordinate)) {
            return Coordinate.VersionOrdering.INCOMPARABLE;
        }
        MavenCoordinate mavenCoordinate = (MavenCoordinate)coordinate;
        return Coordinate.VersionOrdering.fromInt(this.version.compareTo(mavenCoordinate.version));
    }

    @Override
    public CoordinateId id() {
        return new MavenCoordinateId(this.group, this.artifact, this.version);
    }

    @Override
    public Manifest getManifest(Cache cache) {
        for (MavenRepository repository : this.repositories) {
            try {
                return repository.getManifest(this.group, this.artifact, this.version, cache, this.scopes, this.repositories, this.jdkVersion, this.os);
            }
            catch (ArtifactNotFound artifactNotFound) {
            }
        }
        throw new ArtifactNotFound(this.group, this.artifact, this.version);
    }

    @Override
    public Path getLibraryLocation(Cache cache) {
        for (MavenRepository repository : this.repositories) {
            try {
                CacheKey key = repository.cacheKey(this.group, this.artifact, this.version, this.classifier, Extension.JAR);
                return cache.fetchIfAbsent(key, () -> repository.getArtifact(this.group, this.artifact, this.version, this.classifier, Extension.JAR));
            }
            catch (ArtifactNotFound e) {
                LOG.log(System.Logger.Level.TRACE, () -> "Could not find artifact in repository. repository=" + String.valueOf(repository) + ", group=" + String.valueOf(this.group) + ", artifact=" + String.valueOf(this.artifact) + ", version=" + String.valueOf(this.version) + ", classifier=" + String.valueOf(this.classifier) + ", cache=" + String.valueOf(cache), (Throwable)e);
            }
        }
        LOG.log(System.Logger.Level.TRACE, () -> "Could not find artifact in any checked repository. repositories=" + String.valueOf(this.repositories) + ", group=" + String.valueOf(this.group) + ", artifact=" + String.valueOf(this.artifact) + ", version=" + String.valueOf(this.version) + ", classifier=" + String.valueOf(this.classifier) + ", cache=" + String.valueOf(cache));
        throw new ArtifactNotFound(this.group, this.artifact, this.version);
    }

    @Override
    public Optional<Path> getLibrarySourcesLocation(Cache cache) {
        for (MavenRepository repository : this.repositories) {
            try {
                CacheKey key = repository.cacheKey(this.group, this.artifact, this.version, this.sourceClassifier, Extension.JAR);
                return Optional.of(cache.fetchIfAbsent(key, () -> repository.getArtifact(this.group, this.artifact, this.version, this.sourceClassifier, Extension.JAR)));
            }
            catch (ArtifactNotFound e) {
                LOG.log(System.Logger.Level.TRACE, () -> "Could not find sources in repository. repository=" + String.valueOf(repository) + ", group=" + String.valueOf(this.group) + ", artifact=" + String.valueOf(this.artifact) + ", version=" + String.valueOf(this.version) + ", sourceClassifier=" + String.valueOf(this.sourceClassifier) + ", cache=" + String.valueOf(cache), (Throwable)e);
            }
        }
        LOG.log(System.Logger.Level.TRACE, () -> "Could not find sources in any checked repository. repositories=" + String.valueOf(this.repositories) + ", group=" + String.valueOf(this.group) + ", artifact=" + String.valueOf(this.artifact) + ", version=" + String.valueOf(this.version) + ", sourceClassifier=" + String.valueOf(this.sourceClassifier) + ", cache=" + String.valueOf(cache));
        return Optional.empty();
    }

    @Override
    public Optional<Path> getLibraryDocumentationLocation(Cache cache) {
        for (MavenRepository repository : this.repositories) {
            try {
                CacheKey key = repository.cacheKey(this.group, this.artifact, this.version, this.documentationClassifier, Extension.JAR);
                return Optional.of(cache.fetchIfAbsent(key, () -> repository.getArtifact(this.group, this.artifact, this.version, this.documentationClassifier, Extension.JAR)));
            }
            catch (ArtifactNotFound e) {
                LOG.log(System.Logger.Level.TRACE, () -> "Could not find documentation in repository. repository=" + String.valueOf(repository) + ", group=" + String.valueOf(this.group) + ", artifact=" + String.valueOf(this.artifact) + ", version=" + String.valueOf(this.version) + ", documentationClassifier=" + String.valueOf(this.documentationClassifier) + ", cache=" + String.valueOf(cache), (Throwable)e);
            }
        }
        LOG.log(System.Logger.Level.TRACE, () -> "Could not find documentation in any checked repository. repositories=" + String.valueOf(this.repositories) + ", group=" + String.valueOf(this.group) + ", artifact=" + String.valueOf(this.artifact) + ", version=" + String.valueOf(this.version) + ", documentationClassifier=" + String.valueOf(this.documentationClassifier) + ", cache=" + String.valueOf(cache));
        return Optional.empty();
    }
}

