/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Artifact;
import dev.mccue.resolve.Group;
import dev.mccue.resolve.Version;
import dev.mccue.resolve.VersionRange;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

record MavenMetadata(Group group, Artifact artifact, Version latest, Version release, List<Version> versions, LocalDateTime lastUpdated) {
    public MavenMetadata(Group group, Artifact artifact, Version latest, Version release, List<Version> versions, LocalDateTime lastUpdated) {
        this.group = Objects.requireNonNull(group);
        this.artifact = Objects.requireNonNull(artifact);
        this.latest = Objects.requireNonNull(latest);
        this.release = Objects.requireNonNull(release);
        this.versions = List.copyOf(versions);
        this.lastUpdated = Objects.requireNonNull(lastUpdated);
    }

    static MavenMetadata parseXml(String content) {
        var handler = new DefaultHandler(){
            Group group;
            Artifact artifact;
            Version latest;
            Version release;
            final List<Version> versions = new ArrayList<Version>();
            LocalDateTime lastUpdated;
            final StringBuilder characterBuffer = new StringBuilder();
            Consumer<String> next = __ -> {};

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                switch (qName) {
                    case "groupId": {
                        this.next = groupId -> {
                            this.group = new Group((String)groupId);
                        };
                        break;
                    }
                    case "artifactId": {
                        this.next = artifactId -> {
                            this.artifact = new Artifact((String)artifactId);
                        };
                        break;
                    }
                    case "latest": {
                        this.next = latest -> {
                            this.latest = new Version((String)latest);
                        };
                        break;
                    }
                    case "release": {
                        this.next = release -> {
                            this.release = new Version((String)release);
                        };
                        break;
                    }
                    case "version": {
                        this.next = version -> this.versions.add(new Version((String)version));
                        break;
                    }
                    case "lastUpdated": {
                        this.next = lastUpdated -> {
                            this.lastUpdated = LocalDateTime.parse(lastUpdated, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                        };
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.next.accept(this.characterBuffer.toString().trim());
                this.characterBuffer.setLength(0);
                this.next = __ -> {};
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.characterBuffer.append(ch, start, length);
            }
        };
        SAXParserFactory factory = SAXParserFactory.newDefaultInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), handler);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new MavenMetadata(handler.group, handler.artifact, handler.latest, handler.release, handler.versions, handler.lastUpdated);
    }

    Optional<Version> resolveVersionRange(VersionRange range) {
        return this.versions.stream().sorted(Comparator.reverseOrder()).filter(range::includes).findFirst();
    }
}

