/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Artifact;
import dev.mccue.resolve.Cache;
import dev.mccue.resolve.CacheKey;
import dev.mccue.resolve.Group;
import dev.mccue.resolve.Version;
import dev.mccue.resolve.maven.ArtifactNotFound;
import dev.mccue.resolve.maven.ChildHavingPomInfo;
import dev.mccue.resolve.maven.Classifier;
import dev.mccue.resolve.maven.EffectivePomInfo;
import dev.mccue.resolve.maven.Extension;
import dev.mccue.resolve.maven.FileTransport;
import dev.mccue.resolve.maven.HttpTransport;
import dev.mccue.resolve.maven.MavenCoordinate;
import dev.mccue.resolve.maven.MavenMetadata;
import dev.mccue.resolve.maven.Os;
import dev.mccue.resolve.maven.PomInfo;
import dev.mccue.resolve.maven.PomManifest;
import dev.mccue.resolve.maven.PomParent;
import dev.mccue.resolve.maven.PomParser;
import dev.mccue.resolve.maven.Scope;
import dev.mccue.resolve.maven.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class MavenRepository {
    private static final System.Logger LOG = System.getLogger(MavenRepository.class.getName());
    final boolean isSnapshot;
    static final MavenRepository MAVEN_CENTRAL = new MavenRepository("https://repo1.maven.org/maven2/");
    private final Transport transport;

    public static MavenRepository central() {
        return MAVEN_CENTRAL;
    }

    public static MavenRepository remote(String url) {
        return new MavenRepository(url);
    }

    public static MavenRepository remote(String url, Supplier<HttpClient> httpClient) {
        return new MavenRepository(url, httpClient);
    }

    public static MavenRepository remote(String url, Consumer<HttpRequest.Builder> enrichRequest) {
        return new MavenRepository(url, enrichRequest);
    }

    public static MavenRepository remote(String url, Supplier<HttpClient> httpClient, Consumer<HttpRequest.Builder> enrichRequest) {
        return new MavenRepository(url, httpClient, enrichRequest);
    }

    public static MavenRepository local() {
        return new MavenRepository(new FileTransport(Path.of(System.getProperty("user.home"), ".m2")));
    }

    public static MavenRepository local(Path path) {
        return new MavenRepository(new FileTransport(path));
    }

    MavenRepository(String url) {
        this(url, (HttpRequest.Builder request) -> {});
    }

    MavenRepository(String url, Supplier<HttpClient> httpClient) {
        this(url, httpClient, request -> {});
    }

    MavenRepository(String url, Consumer<HttpRequest.Builder> enrichRequest) {
        this(url, HttpClient::newHttpClient, enrichRequest);
    }

    MavenRepository(String url, Supplier<HttpClient> httpClient, Consumer<HttpRequest.Builder> enrichRequest) {
        this.transport = new HttpTransport(url, httpClient, enrichRequest);
        this.isSnapshot = false;
    }

    MavenRepository(Transport transport) {
        this.transport = transport;
        this.isSnapshot = false;
    }

    CacheKey cacheKey(Group group, Artifact artifact, Version version, Classifier classifier, Extension extension) {
        ArrayList<String> key = new ArrayList<String>(this.transport.cachePrefix());
        key.addAll(MavenRepository.getArtifactPath(group, artifact, version, classifier, extension));
        return new CacheKey(key);
    }

    InputStream getArtifact(Group group, Artifact artifact, Version version, Classifier classifier, Extension extension) throws ArtifactNotFound {
        Transport.GetFileResult getFileResult;
        LOG.log(System.Logger.Level.TRACE, () -> "About to get artifact. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", version=" + String.valueOf(version) + ", classifier=" + String.valueOf(classifier) + ", extension=" + String.valueOf(extension) + ", transport=" + String.valueOf(this.transport));
        Transport.GetFileResult getFileResult2 = getFileResult = this.transport.getFile(MavenRepository.getArtifactPath(group, artifact, version, classifier, extension));
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Transport.GetFileResult.Success.class, Transport.GetFileResult.NotFound.class, Transport.GetFileResult.Error.class}, (Object)getFileResult2, n)) {
            case 0: {
                Transport.GetFileResult.Success success = (Transport.GetFileResult.Success)getFileResult2;
                InputStream inputStream = success.inputStream();
                LOG.log(System.Logger.Level.TRACE, () -> "Successfully got file for artifact. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", version=" + String.valueOf(version) + ", classifier=" + String.valueOf(classifier) + ", extension=" + String.valueOf(extension) + ", transport=" + String.valueOf(this.transport));
                return inputStream;
            }
            case 1: {
                Transport.GetFileResult.NotFound notFound = (Transport.GetFileResult.NotFound)getFileResult2;
                LOG.log(System.Logger.Level.TRACE, () -> "Did not find file for artifact. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", version=" + String.valueOf(version) + ", classifier=" + String.valueOf(classifier) + ", extension=" + String.valueOf(extension) + ", transport=" + String.valueOf(this.transport));
                throw new ArtifactNotFound(group, artifact, version);
            }
            case 2: {
                Transport.GetFileResult.Error error = (Transport.GetFileResult.Error)getFileResult2;
                Throwable e = error.throwable();
                LOG.log(System.Logger.Level.TRACE, () -> "Encountered error getting file for metadata. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", version=" + String.valueOf(version) + ", classifier=" + String.valueOf(classifier) + ", extension=" + String.valueOf(extension) + ", transport=" + String.valueOf(this.transport), e);
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException();
    }

    InputStream getMetadata(Group group, Artifact artifact) {
        Transport.GetFileResult getFileResult;
        LOG.log(System.Logger.Level.TRACE, () -> "About to get metadata. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", transport=" + String.valueOf(this.transport));
        Transport.GetFileResult getFileResult2 = getFileResult = this.transport.getFile(MavenRepository.getMetadataPath(group, artifact));
        Objects.requireNonNull(getFileResult2);
        Transport.GetFileResult getFileResult3 = getFileResult2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Transport.GetFileResult.Success.class, Transport.GetFileResult.NotFound.class, Transport.GetFileResult.Error.class}, (Object)getFileResult3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Transport.GetFileResult.Success success = (Transport.GetFileResult.Success)getFileResult3;
                InputStream inputStream = success.inputStream();
                LOG.log(System.Logger.Level.TRACE, () -> "Successfully got file for metadata. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", transport=" + String.valueOf(this.transport));
                return inputStream;
            }
            case 1: {
                Transport.GetFileResult.NotFound __ = (Transport.GetFileResult.NotFound)getFileResult3;
                LOG.log(System.Logger.Level.TRACE, () -> "Did not find file for metadata. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", transport=" + String.valueOf(this.transport));
                throw new ArtifactNotFound(group, artifact);
            }
            case 2: 
        }
        Transport.GetFileResult.Error error = (Transport.GetFileResult.Error)getFileResult3;
        Throwable e = error.throwable();
        LOG.log(System.Logger.Level.TRACE, () -> "Encountered error getting file for metadata. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", transport=" + String.valueOf(this.transport), e);
        throw new RuntimeException(e);
    }

    static List<String> getArtifactPath(Group group, Artifact artifact, Version version, Classifier classifier, Extension extension) {
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(group.value().split("\\.")));
        path.add(artifact.value());
        path.add(version.toString());
        path.add(String.valueOf(artifact) + "-" + String.valueOf(version) + (String)(!classifier.equals(Classifier.EMPTY) ? "-" + classifier.value() : "") + (String)(!extension.equals(Extension.EMPTY) ? "." + String.valueOf(extension) : ""));
        return List.copyOf(path);
    }

    static List<String> getMetadataPath(Group group, Artifact artifact) {
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(group.value().split("\\.")));
        path.add(artifact.value());
        path.add("maven-metadata.xml");
        return List.copyOf(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PomInfo getPomInfo(Group group, Artifact artifact, Version version, Cache cache) throws ArtifactNotFound {
        LOG.log(System.Logger.Level.TRACE, () -> "About to fetch pom file. group=" + String.valueOf(group) + ", artifact=" + String.valueOf(artifact) + ", version=" + String.valueOf(version) + ", cache=" + String.valueOf(cache));
        CacheKey key = this.cacheKey(group, artifact, version, Classifier.EMPTY, Extension.POM);
        try {
            if (cache == null) {
                try (InputStream data = this.getArtifact(group, artifact, version, Classifier.EMPTY, Extension.POM);){
                    PomInfo pomInfo = PomParser.parse(new String(data.readAllBytes(), StandardCharsets.UTF_8));
                    return pomInfo;
                }
            }
            Path pomPath = cache.fetchIfAbsent(key, () -> this.getArtifact(group, artifact, version, Classifier.EMPTY, Extension.POM));
            try (InputStream data = Files.newInputStream(pomPath, new OpenOption[0]);){
                PomInfo pomInfo = PomParser.parse(new String(data.readAllBytes(), StandardCharsets.UTF_8));
                return pomInfo;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Optional<PomInfo> getParentPomInfo(PomInfo pomInfo, Cache cache) {
        PomParent pomParent = pomInfo.parent();
        if (pomParent instanceof PomParent.Declared) {
            PomParent.Declared declaredPom = (PomParent.Declared)pomParent;
            return Optional.of(this.getPomInfo(new Group(declaredPom.groupId().value()), new Artifact(declaredPom.artifactId().value()), new Version(declaredPom.version().value()), cache));
        }
        return Optional.empty();
    }

    ChildHavingPomInfo getAllPoms(Group group, Artifact artifact, Version version, Cache cache) {
        PomInfo parentPom;
        ArrayList<PomInfo> poms = new ArrayList<PomInfo>();
        PomInfo pom = this.getPomInfo(group, artifact, version, cache);
        poms.add(pom);
        while ((parentPom = (PomInfo)this.getParentPomInfo((PomInfo)poms.get(poms.size() - 1), cache).orElse(null)) != null) {
            poms.add(parentPom);
        }
        Iterator iterator = poms.iterator();
        PomInfo currentPom = (PomInfo)iterator.next();
        ChildHavingPomInfo childHavingPomInfo = new ChildHavingPomInfo(currentPom.groupId(), currentPom.artifactId(), currentPom.version(), currentPom.dependencies(), currentPom.dependencyManagement(), currentPom.properties(), currentPom.packaging(), Optional.empty());
        while (iterator.hasNext()) {
            PomInfo parentPom2 = (PomInfo)iterator.next();
            childHavingPomInfo = new ChildHavingPomInfo(parentPom2.groupId(), parentPom2.artifactId(), parentPom2.version(), parentPom2.dependencies(), parentPom2.dependencyManagement(), parentPom2.properties(), parentPom2.packaging(), Optional.of(childHavingPomInfo));
        }
        return childHavingPomInfo;
    }

    PomManifest getManifest(Group group, Artifact artifact, Version version, Cache cache, List<Scope> scopes, List<MavenRepository> childRepositories, Runtime.Version jdkVersion, Os os) {
        EffectivePomInfo effectivePom = EffectivePomInfo.from(this.getAllPoms(group, artifact, version, cache), jdkVersion, os);
        return PomManifest.from(effectivePom.resolveImports(this, cache, jdkVersion, os), scopes, (depGroup, depArtifact, depVersion, defaultClassifier) -> new MavenCoordinate(depGroup, depArtifact, depVersion, childRepositories, scopes, defaultClassifier, Classifier.SOURCES, Classifier.JAVADOC, jdkVersion, os)).normalize(cache);
    }

    MavenMetadata getMavenMetadata(Group group, Artifact artifact) throws IOException {
        return MavenMetadata.parseXml(new String(this.getMetadata(group, artifact).readAllBytes(), StandardCharsets.UTF_8));
    }

    public String toString() {
        return "MavenRepository[transport=" + String.valueOf(this.transport) + "]";
    }
}

