/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.doc.Maven;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

@Maven(value="    https://maven.apache.org/enforcer/enforcer-rules/requireOS.html\n    https://maven.apache.org/guides/introduction/introduction-to-profiles.html#os\n")
public record Os(String name, String arch, String version) {
    private static final Set<String> STANDARD_FAMILIES = Set.of("windows", "os/2", "netware", "mac", "os/400", "openvms");
    private static final Set<String> KNOWN_FAMILIES;

    public Os(String name, String arch, String version) {
        String archNormalized = arch.toLowerCase(Locale.US);
        archNormalized = archNormalized.equals("x86-64") ? "x86_64" : archNormalized;
        String nameNormalized = name.toLowerCase(Locale.US);
        String versionNormalized = version.toLowerCase(Locale.US);
        this.name = nameNormalized;
        this.arch = archNormalized;
        this.version = versionNormalized;
    }

    public Os() {
        this(System.getProperty("os.name").toLowerCase(Locale.US), System.getProperty("os.arch").toLowerCase(Locale.US), System.getProperty("os.version").toLowerCase(Locale.US));
    }

    static {
        HashSet<String> knownFamilies = new HashSet<String>(STANDARD_FAMILIES);
        knownFamilies.add("dos");
        knownFamilies.add("tandem");
        knownFamilies.add("win9x");
        knownFamilies.add("z/os");
        KNOWN_FAMILIES = Set.copyOf(knownFamilies);
    }
}

