/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Artifact;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

sealed interface PomArtifactId {
    public Artifact orElseThrow();

    public PomArtifactId map(Function<String, String> var1);

    public void ifDeclared(Consumer<String> var1);

    public record Declared(String value) implements PomArtifactId
    {
        public Declared(String value) {
            this.value = Objects.requireNonNull(value).trim();
        }

        @Override
        public Artifact orElseThrow() {
            return new Artifact(this.value);
        }

        @Override
        public PomArtifactId map(Function<String, String> f) {
            return new Declared(f.apply(this.value));
        }

        @Override
        public void ifDeclared(Consumer<String> cb) {
            cb.accept(this.value);
        }
    }

    public static enum Undeclared implements PomArtifactId
    {
        INSTANCE;


        @Override
        public Artifact orElseThrow() {
            throw new RuntimeException("No artifact declared");
        }

        @Override
        public PomArtifactId map(Function<String, String> f) {
            return this;
        }

        @Override
        public void ifDeclared(Consumer<String> cb) {
        }

        public String toString() {
            return "Undeclared[]";
        }
    }
}

