/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.Artifact;
import dev.mccue.resolve.Cache;
import dev.mccue.resolve.Dependency;
import dev.mccue.resolve.Exclusion;
import dev.mccue.resolve.Exclusions;
import dev.mccue.resolve.Group;
import dev.mccue.resolve.Library;
import dev.mccue.resolve.Manifest;
import dev.mccue.resolve.Version;
import dev.mccue.resolve.maven.Classifier;
import dev.mccue.resolve.maven.EffectivePomInfo;
import dev.mccue.resolve.maven.MavenCoordinate;
import dev.mccue.resolve.maven.PomArtifactId;
import dev.mccue.resolve.maven.PomDependency;
import dev.mccue.resolve.maven.PomExclusion;
import dev.mccue.resolve.maven.PomGroupId;
import dev.mccue.resolve.maven.PomVersion;
import dev.mccue.resolve.maven.Scope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

record PomManifest(List<Dependency> dependencies) implements Manifest
{
    PomManifest normalize(Cache cache) {
        return new PomManifest(this.dependencies.stream().map(dependency -> new Dependency(dependency.library(), dependency.coordinate().normalize(dependency.library(), cache), dependency.exclusions())).toList());
    }

    public static PomManifest from(EffectivePomInfo effectivePomInfo, List<Scope> scopes, MavenCoordinateMaker makeCoordinate) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        HashMap<ManagedDependencyKey, PomDependency> dependencyManagement = new HashMap<ManagedDependencyKey, PomDependency>();
        for (PomDependency managedDependency : effectivePomInfo.dependencyManagement()) {
            dependencyManagement.put(ManagedDependencyKey.from(managedDependency), managedDependency);
        }
        for (PomDependency dependency : effectivePomInfo.dependencies()) {
            Set<PomExclusion> exclusions;
            if (!scopes.contains(dependency.scope().orElse(Scope.COMPILE)) || dependency.optional().asBoolean()) continue;
            PomDependency managed = (PomDependency)dependencyManagement.get(ManagedDependencyKey.from(dependency));
            PomVersion version = dependency.version();
            if (version instanceof PomVersion.Undeclared && managed != null) {
                version = managed.version();
            }
            if ((exclusions = dependency.exclusions()).isEmpty() && managed != null) {
                exclusions = managed.exclusions();
            }
            PomGroupId group = dependency.groupId();
            PomArtifactId artifact = dependency.artifactId();
            if (!(group instanceof PomGroupId.Declared)) {
                throw new RuntimeException("Group Id is not defined");
            }
            PomGroupId.Declared declaredGroup = (PomGroupId.Declared)group;
            if (!(artifact instanceof PomArtifactId.Declared)) {
                throw new RuntimeException("Artifact Id is not defined");
            }
            PomArtifactId.Declared declaredArtifact = (PomArtifactId.Declared)artifact;
            if (!(version instanceof PomVersion.Declared)) {
                throw new RuntimeException("Version is not defined");
            }
            PomVersion.Declared declaredVersion = (PomVersion.Declared)version;
            dependencies.add(new Dependency(new Library(new Group(declaredGroup.value()), new Artifact(declaredArtifact.value()), dependency.classifier().orElse(Classifier.EMPTY).asVariant()), makeCoordinate.make(new Group(declaredGroup.value()), new Artifact(declaredArtifact.value()), new Version(declaredVersion.value()), dependency.classifier().orElse(Classifier.EMPTY)), Exclusions.of(exclusions.stream().map(pomExclusion -> {
                PomGroupId patt0$temp = pomExclusion.groupId();
                if (!(patt0$temp instanceof PomGroupId.Declared)) {
                    throw new RuntimeException("Exclusion group id not declared");
                }
                PomGroupId.Declared declaredExclusionGroup = (PomGroupId.Declared)patt0$temp;
                PomArtifactId patt1$temp = pomExclusion.artifactId();
                if (!(patt1$temp instanceof PomArtifactId.Declared)) {
                    throw new RuntimeException("Exclusion group id not declared");
                }
                PomArtifactId.Declared declaredExclusionArtifact = (PomArtifactId.Declared)patt1$temp;
                return new Exclusion(new Group(declaredExclusionGroup.value()), new Artifact(declaredExclusionArtifact.value()));
            }).toList())));
        }
        return new PomManifest(List.copyOf(dependencies));
    }

    private record ManagedDependencyKey(PomGroupId groupId, PomArtifactId artifactId) {
        static ManagedDependencyKey from(PomDependency pomDependency) {
            return new ManagedDependencyKey(pomDependency.groupId(), pomDependency.artifactId());
        }
    }

    static interface MavenCoordinateMaker {
        public MavenCoordinate make(Group var1, Artifact var2, Version var3, Classifier var4);
    }
}

