/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import dev.mccue.resolve.maven.PomActivation;
import dev.mccue.resolve.maven.PomArtifactId;
import dev.mccue.resolve.maven.PomClassifier;
import dev.mccue.resolve.maven.PomDependency;
import dev.mccue.resolve.maven.PomExclusion;
import dev.mccue.resolve.maven.PomGroupId;
import dev.mccue.resolve.maven.PomInfo;
import dev.mccue.resolve.maven.PomOptionality;
import dev.mccue.resolve.maven.PomPackaging;
import dev.mccue.resolve.maven.PomParent;
import dev.mccue.resolve.maven.PomProfile;
import dev.mccue.resolve.maven.PomProperty;
import dev.mccue.resolve.maven.PomScope;
import dev.mccue.resolve.maven.PomType;
import dev.mccue.resolve.maven.PomVersion;
import dev.mccue.resolve.util.LL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class PomParser
extends DefaultHandler {
    final State state = new State();
    LL<String> paths = new LL.Nil<String>();
    LL<Optional<Handler>> handlers = new LL.Nil<Optional<Handler>>();
    StringBuilder characterBuffer = new StringBuilder();
    private static final Map<LL<String>, Handler> HANDLER_MAP;

    PomParser() {
    }

    @Override
    public void startElement(String _uri, String _localName, String tagName, Attributes _attributes) {
        LL.Cons<String> paths = this.paths.prepend(tagName);
        this.paths = paths;
        Handler handler = HANDLER_MAP.getOrDefault(this.paths, HANDLER_MAP.get(paths.tail().prepend("*")));
        this.handlers = this.handlers.prepend(Optional.ofNullable(handler));
        Handler handler2 = handler;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SectionHandler.class, PropertyHandler.class}, (Object)handler2, n)) {
            case 0: {
                SectionHandler s = (SectionHandler)handler2;
                s.start(this.state);
                break;
            }
            case 1: {
                PropertyHandler p = (PropertyHandler)handler2;
                p.name(this.state, tagName);
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean readContent = this.handlers.headOption().flatMap(handlerOpt -> handlerOpt.map(handler -> handler instanceof PropertyHandler || handler instanceof ContentHandler)).orElse(false);
        if (readContent) {
            this.characterBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String _uri, String _localName, String tagName) {
        Optional handlerOpt = this.handlers.headOption().flatMap(Function.identity());
        this.paths = this.paths.assumeNotEmpty().tail();
        this.handlers = this.handlers.assumeNotEmpty().tail();
        handlerOpt.ifPresent(handler -> {
            Handler handler2 = handler;
            Objects.requireNonNull(handler2);
            Handler selector0$temp = handler2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PropertyHandler.class, ContentHandler.class, SectionHandler.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PropertyHandler p = (PropertyHandler)selector0$temp;
                    p.content(this.state, this.characterBuffer.toString());
                    break;
                }
                case 1: {
                    ContentHandler c = (ContentHandler)selector0$temp;
                    c.content(this.state, this.characterBuffer.toString());
                    break;
                }
                case 2: {
                    SectionHandler s = (SectionHandler)selector0$temp;
                    s.end(this.state);
                }
            }
        });
        this.characterBuffer.setLength(0);
    }

    private static List<Handler> dependencyHandlers(final LL<String> prefix, final AddDepHandler addDepHandler) {
        return List.of(new SectionHandler(){

            @Override
            public void start(State state) {
                state.dependencyGroupId = PomGroupId.Undeclared.INSTANCE;
                state.dependencyArtifactId = PomArtifactId.Undeclared.INSTANCE;
                state.dependencyVersion = PomVersion.Undeclared.INSTANCE;
                state.dependencyOptional = PomOptionality.Undeclared.INSTANCE;
                state.dependencyScope = PomScope.Undeclared.INSTANCE;
                state.dependencyType = PomType.Undeclared.INSTANCE;
                state.dependencyClassifier = PomClassifier.Undeclared.INSTANCE;
                state.dependencyExclusions.clear();
            }

            @Override
            public void end(State state) {
                PomDependency dependency = new PomDependency(state.dependencyGroupId, state.dependencyArtifactId, state.dependencyVersion, state.dependencyExclusions, state.dependencyType, state.dependencyClassifier, state.dependencyOptional, state.dependencyScope);
                addDepHandler.add(state, dependency);
            }

            @Override
            public LL<String> path() {
                return prefix;
            }
        }, PomParser.content(new LL.Cons<String>("groupId", prefix), (State state, String content) -> {
            state.dependencyGroupId = new PomGroupId.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("artifactId", prefix), (State state, String content) -> {
            state.dependencyArtifactId = new PomArtifactId.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("version", prefix), (State state, String content) -> {
            state.dependencyVersion = new PomVersion.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("optional", prefix), (State state, String content) -> {
            state.dependencyOptional = new PomOptionality.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("scope", prefix), (State state, String content) -> {
            state.dependencyScope = new PomScope.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("type", prefix), (State state, String content) -> {
            state.dependencyType = new PomType.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("classifier", prefix), (State state, String content) -> {
            state.dependencyClassifier = new PomClassifier.Declared((String)content);
        }), new SectionHandler(){

            @Override
            public void start(State state) {
                state.dependencyExclusionGroupId = PomGroupId.Undeclared.INSTANCE;
                state.dependencyExclusionArtifactId = PomArtifactId.Undeclared.INSTANCE;
            }

            @Override
            public void end(State state) {
                state.dependencyExclusions.add(new PomExclusion(state.dependencyExclusionGroupId, state.dependencyExclusionArtifactId));
            }

            @Override
            public LL<String> path() {
                return new LL.Cons<String>("exclusion", new LL.Cons<String>("exclusions", prefix));
            }
        }, PomParser.content(new LL.Cons<String>("groupId", new LL.Cons<String>("exclusion", new LL.Cons<String>("exclusions", prefix))), (State state, String content) -> {
            state.dependencyExclusionGroupId = new PomGroupId.Declared((String)content);
        }), PomParser.content(new LL.Cons<String>("artifactId", new LL.Cons<String>("exclusion", new LL.Cons<String>("exclusions", prefix))), (State state, String content) -> {
            state.dependencyExclusionArtifactId = new PomArtifactId.Declared((String)content);
        }));
    }

    private static List<Handler> propertyHandlers(final LL<String> prefix, final AddPropertyHandler add) {
        return List.of(new PropertyHandler(){

            @Override
            public void name(State state, String name) {
                state.propertyName = name;
            }

            @Override
            public void content(State state, String content) {
                add.add(state, Objects.requireNonNull(state.propertyName), content);
                state.propertyName = null;
            }

            @Override
            public LL<String> path() {
                return new LL.Cons<String>("*", prefix);
            }
        });
    }

    private static Handler content(List<String> path, BiConsumer<State, String> callback) {
        return PomParser.content(LL.fromJavaList(path), callback);
    }

    private static Handler content(final LL<String> path, final BiConsumer<State, String> callback) {
        return new ContentHandler(){

            @Override
            public void content(State state, String content) {
                callback.accept(state, content);
            }

            @Override
            public LL<String> path() {
                return path;
            }
        };
    }

    private static List<Handler> profileHandlers(final LL<String> prefix, final AddProfileHandler add) {
        ArrayList<Handler> handlers = new ArrayList<Handler>(List.of(new SectionHandler(){

            @Override
            public void start(State state) {
                state.profileId = "";
                state.profileActiveByDefaultOpt = Optional.empty();
                state.profileDependencies.clear();
                state.profileDependencyManagement.clear();
                state.profileProperties.clear();
                state.profileActivationProperties.clear();
                state.profileActivationOsArchOpt = Optional.empty();
                state.profileActivationOsFamilyOpt = Optional.empty();
                state.profileActivationOsNameOpt = Optional.empty();
                state.profileActivationOsVersionOpt = Optional.empty();
                state.profileActivationJdkOpt = new PomActivation.Jdk.Unspecified();
            }

            @Override
            public void end(State state) {
                PomProfile profile = new PomProfile(state.profileId, state.profileActiveByDefaultOpt, new PomActivation(List.copyOf(state.profileActivationProperties), new PomActivation.Os(state.profileActivationOsArchOpt, state.profileActivationOsFamilyOpt.stream().collect(Collectors.toUnmodifiableSet()), state.profileActivationOsNameOpt, state.profileActivationOsVersionOpt), state.profileActivationJdkOpt), List.copyOf(state.profileDependencies), List.copyOf(state.profileDependencyManagement), List.copyOf(state.profileProperties));
                add.add(state, profile);
            }

            @Override
            public LL<String> path() {
                return prefix;
            }
        }, PomParser.content(new LL.Cons<String>("id", prefix), (State state, String content) -> {
            state.profileId = content;
        }), PomParser.content(new LL.Cons<String>("activeByDefault", new LL.Cons<String>("activation", new LL.Nil())), (State state, String content) -> {
            state.profileActiveByDefaultOpt = switch (content) {
                case "true" -> Optional.of(true);
                case "false" -> Optional.of(false);
                default -> Optional.empty();
            };
        }), PomParser.content(new LL.Cons<String>("value", new LL.Cons<String>("property", new LL.Cons<String>("activation", prefix))), (State state, String content) -> {
            state.profilePropertyValueOpt = Optional.of(content);
        }), PomParser.content(new LL.Cons<String>("arch", new LL.Cons<String>("os", new LL.Cons<String>("activation", prefix))), (State state, String content) -> {
            state.profileActivationOsArchOpt = Optional.of(content);
        }), PomParser.content(new LL.Cons<String>("family", new LL.Cons<String>("os", new LL.Cons<String>("activation", prefix))), (State state, String content) -> {
            state.profileActivationOsFamilyOpt = Optional.of(content);
        }), PomParser.content(new LL.Cons<String>("artifactId", new LL.Cons<String>("os", new LL.Cons<String>("activation", prefix))), (State state, String content) -> {
            state.profileActivationOsNameOpt = Optional.of(content);
        }), PomParser.content(new LL.Cons<String>("version", new LL.Cons<String>("os", new LL.Cons<String>("activation", prefix))), (State state, String content) -> {
            state.profileActivationOsVersionOpt = Optional.of(content);
        }), PomParser.content(new LL.Cons<String>("jdk", new LL.Cons<String>("activation", prefix)), (State state, String content) -> {})));
        handlers.addAll(PomParser.dependencyHandlers(new LL.Cons<String>("dependency", new LL.Cons<String>("dependencies", prefix)), (state, pomDependency) -> state.profileDependencies.add(pomDependency)));
        handlers.addAll(PomParser.dependencyHandlers(new LL.Cons<String>("dependency", new LL.Cons<String>("dependencies", new LL.Cons<String>("dependencyManagement", prefix))), (state, pomDependency) -> state.profileDependencyManagement.add(pomDependency)));
        handlers.addAll(PomParser.propertyHandlers(new LL.Cons<String>("property", new LL.Cons<String>("activation", prefix)), (state, key, value) -> state.profileProperties.add(new PomProperty(key, value))));
        return handlers;
    }

    PomInfo pomInfo() {
        return this.state.pomInfo();
    }

    static PomInfo parse(String pomString) {
        PomParser pomParser = new PomParser();
        SAXParserFactory factory = SAXParserFactory.newDefaultInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(pomString.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)pomParser);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(pomString, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return pomParser.pomInfo();
    }

    static {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        handlers.addAll(List.of(PomParser.content(List.of("groupId", "project"), (State state, String content) -> {
            state.groupId = new PomGroupId.Declared((String)content);
        }), PomParser.content(List.of("artifactId", "project"), (State state, String content) -> {
            state.artifactId = new PomArtifactId.Declared((String)content);
        }), PomParser.content(List.of("version", "project"), (State state, String content) -> {
            state.version = new PomVersion.Declared((String)content);
        }), PomParser.content(List.of("groupId", "parent", "project"), (State state, String content) -> {
            state.parentGroupId = new PomGroupId.Declared((String)content);
        }), PomParser.content(List.of("artifactId", "parent", "project"), (State state, String content) -> {
            state.parentArtifactId = new PomArtifactId.Declared((String)content);
        }), PomParser.content(List.of("version", "parent", "project"), (State state, String content) -> {
            state.parentVersion = new PomVersion.Declared((String)content);
        }), PomParser.content(List.of("packaging", "project"), (State state, String content) -> {
            state.packaging = new PomPackaging.Declared((String)content);
        })));
        handlers.addAll(PomParser.dependencyHandlers(LL.fromJavaList(List.of("dependency", "dependencies", "project")), (state, dependency) -> state.dependencies.add(dependency)));
        handlers.addAll(PomParser.dependencyHandlers(LL.fromJavaList(List.of("dependency", "dependencies", "dependencyManagement", "project")), (state, dependency) -> state.dependencyManagement.add(dependency)));
        handlers.addAll(PomParser.propertyHandlers(LL.fromJavaList(List.of("properties", "project")), (state, key, value) -> state.properties.add(new PomProperty(key, value.trim()))));
        handlers.addAll(PomParser.profileHandlers(LL.fromJavaList(List.of("profile", "profiles", "project")), (state, profile) -> state.profiles.add(profile)));
        HANDLER_MAP = handlers.stream().collect(Collectors.toUnmodifiableMap(Handler::path, handler -> handler));
    }

    private static final class State {
        PomGroupId groupId = PomGroupId.Undeclared.INSTANCE;
        PomArtifactId artifactId = PomArtifactId.Undeclared.INSTANCE;
        PomVersion version = PomVersion.Undeclared.INSTANCE;
        PomGroupId parentGroupId = PomGroupId.Undeclared.INSTANCE;
        PomArtifactId parentArtifactId = PomArtifactId.Undeclared.INSTANCE;
        PomVersion parentVersion = PomVersion.Undeclared.INSTANCE;
        PomPackaging packaging = PomPackaging.Undeclared.INSTANCE;
        final ArrayList<PomDependency> dependencies = new ArrayList();
        final ArrayList<PomDependency> dependencyManagement = new ArrayList();
        final ArrayList<PomProperty> properties = new ArrayList();
        final ArrayList<PomProfile> profiles = new ArrayList();
        @Temporary
        PomGroupId dependencyGroupId = PomGroupId.Undeclared.INSTANCE;
        @Temporary
        PomArtifactId dependencyArtifactId = PomArtifactId.Undeclared.INSTANCE;
        @Temporary
        PomVersion dependencyVersion = PomVersion.Undeclared.INSTANCE;
        @Temporary
        PomOptionality dependencyOptional = PomOptionality.Undeclared.INSTANCE;
        @Temporary
        PomScope dependencyScope = PomScope.Undeclared.INSTANCE;
        @Temporary
        PomType dependencyType = PomType.Undeclared.INSTANCE;
        @Temporary
        PomClassifier dependencyClassifier = PomClassifier.Undeclared.INSTANCE;
        final LinkedHashSet<PomExclusion> dependencyExclusions = new LinkedHashSet();
        @Temporary
        PomGroupId dependencyExclusionGroupId = PomGroupId.Undeclared.INSTANCE;
        @Temporary
        PomArtifactId dependencyExclusionArtifactId = PomArtifactId.Undeclared.INSTANCE;
        @Temporary
        String propertyName = null;
        String profileId = "";
        final ArrayList<PomDependency> profileDependencies = new ArrayList();
        final ArrayList<PomDependency> profileDependencyManagement = new ArrayList();
        final ArrayList<PomProperty> profileProperties = new ArrayList();
        final ArrayList<PomProperty> profileActivationProperties = new ArrayList();
        Optional<Boolean> profileActiveByDefaultOpt = Optional.empty();
        Optional<String> profilePropertyNameOpt = Optional.empty();
        Optional<String> profilePropertyValueOpt = Optional.empty();
        Optional<String> profileActivationOsArchOpt = Optional.empty();
        Optional<String> profileActivationOsFamilyOpt = Optional.empty();
        Optional<String> profileActivationOsNameOpt = Optional.empty();
        Optional<String> profileActivationOsVersionOpt = Optional.empty();
        PomActivation.Jdk profileActivationJdkOpt = new PomActivation.Jdk.Unspecified();

        private State() {
        }

        PomInfo pomInfo() {
            PomParent parent;
            block3: {
                PomArtifactId.Declared declaredParentArtifactId;
                PomGroupId.Declared declaredParentGroupId;
                Object object;
                block5: {
                    block4: {
                        block2: {
                            if (!(this.parentGroupId instanceof PomGroupId.Undeclared) || !(this.parentArtifactId instanceof PomArtifactId.Undeclared) || !(this.parentVersion instanceof PomVersion.Undeclared)) break block2;
                            parent = PomParent.Undeclared.INSTANCE;
                            break block3;
                        }
                        object = this.parentGroupId;
                        if (!(object instanceof PomGroupId.Declared)) break block4;
                        declaredParentGroupId = (PomGroupId.Declared)object;
                        object = this.parentArtifactId;
                        if (!(object instanceof PomArtifactId.Declared)) break block4;
                        declaredParentArtifactId = (PomArtifactId.Declared)object;
                        object = this.parentVersion;
                        if (object instanceof PomVersion.Declared) break block5;
                    }
                    throw new RuntimeException("Parent must have group, artifact, and version declared");
                }
                PomVersion.Declared declaredParentVersion = (PomVersion.Declared)object;
                parent = new PomParent.Declared(declaredParentGroupId, declaredParentArtifactId, declaredParentVersion);
            }
            return new PomInfo(this.groupId, this.artifactId, this.version, List.copyOf(this.dependencies), parent, List.copyOf(this.dependencyManagement), List.copyOf(this.properties), this.packaging, List.copyOf(this.profiles));
        }
    }

    private static sealed interface Handler
    permits SectionHandler, ContentHandler, PropertyHandler {
        public LL<String> path();
    }

    private static non-sealed interface SectionHandler
    extends Handler {
        public void start(State var1);

        public void end(State var1);
    }

    private static non-sealed interface PropertyHandler
    extends Handler {
        public void name(State var1, String var2);

        public void content(State var1, String var2);
    }

    private static interface AddDepHandler {
        public void add(State var1, PomDependency var2);
    }

    private static interface AddPropertyHandler {
        public void add(State var1, String var2, String var3);
    }

    private static interface AddProfileHandler {
        public void add(State var1, PomProfile var2);
    }

    private static non-sealed interface ContentHandler
    extends Handler {
        public void content(State var1, String var2);
    }

    private static @interface Temporary {
    }
}

