/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.maven;

import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.NullMarked;

@NullMarked
record Type(String value) implements Comparable<Type>
{
    public static final Type JAR = new Type("jar");
    public static final Type TEST_JAR = new Type("test-jar");
    public static final Type BUNDLE = new Type("bundle");
    public static final Type DOC = new Type("doc");
    public static final Type SOURCE = new Type("src");
    public static final Type JAVADOC = new Type("javadoc");
    public static final Type JAVA_SOURCE = new Type("java-source");
    public static final Type IVY = new Type("ivy");
    public static final Type POM = new Type("pom");
    public static final Type EMPTY = new Type("");
    public static final Type ALL = new Type("*");

    public Type {
        Objects.requireNonNull(value, "value must not be null");
    }

    @Override
    public int compareTo(Type type) {
        return this.value.compareTo(type.value);
    }

    public Type map(Function<String, String> f) {
        return new Type(f.apply(this.value));
    }

    @Override
    public String toString() {
        if (this.equals(EMPTY)) {
            return "Type[EMPTY]";
        }
        return "Type[value='" + this.value + "']";
    }
}

