/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.resolve.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public sealed interface LL<T>
extends Iterable<T> {
    default public Cons<T> prepend(T first) {
        return new Cons<T>(first, this);
    }

    public LL<T> reverse();

    default public Cons<T> append(T last) {
        return this.reverse().prepend(last).reverse();
    }

    public Optional<T> headOption();

    public boolean isEmpty();

    public static <T> LL<T> fromJavaList(List<T> list) {
        Record head = new Nil();
        for (int i = list.size() - 1; i >= 0; --i) {
            head = new Cons<T>(list.get(i), head);
        }
        return head;
    }

    default public List<T> toJavaList() {
        ArrayList l = new ArrayList();
        LL head = this;
        while (head instanceof Cons) {
            Cons cons = (Cons)head;
            l.add(cons.head);
            head = cons.tail;
        }
        return List.copyOf(l);
    }

    public boolean isPrefix(LL<T> var1);

    default public boolean isSuffix(LL<T> other) {
        return this.reverse().isPrefix(other.reverse());
    }

    default public Cons<T> assumeNotEmpty() {
        LL lL = this;
        if (!(lL instanceof Cons)) {
            throw new IllegalStateException("Assumed to be not empty");
        }
        Cons cons = (Cons)lL;
        return cons;
    }

    @Override
    default public Iterator<T> iterator() {
        final LL self = this;
        return new Iterator<T>(){
            LL<T> head;
            {
                this.head = self;
            }

            @Override
            public boolean hasNext() {
                return this.head instanceof Cons;
            }

            @Override
            public T next() {
                LL lL = this.head;
                if (lL instanceof Cons) {
                    Cons cons = (Cons)lL;
                    this.head = cons.tail;
                    return cons.head;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public record Cons<T>(T head, LL<T> tail) implements LL<T>
    {
        public Cons {
            Objects.requireNonNull(head, "head must not be null");
            Objects.requireNonNull(tail, "tail must not be null");
        }

        @Override
        public Cons<T> reverse() {
            LL<T> top = this.tail;
            Cons<T> reversed = new Nil<T>().prepend(this.head);
            while (top instanceof Cons) {
                Cons hasHead = (Cons)top;
                reversed = reversed.prepend(hasHead.head);
                top = hasHead.tail;
            }
            return reversed;
        }

        @Override
        public Optional<T> headOption() {
            return Optional.of(this.head);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isPrefix(LL<T> other) {
            if (!(other instanceof Cons)) return false;
            Cons otherCons = (Cons)other;
            if (!otherCons.head.equals(this.head)) return false;
            if (!this.tail.isPrefix(otherCons.tail)) return false;
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            LL<T> self = this;
            while (self instanceof Cons) {
                Cons hasHead = self;
                sb.append(hasHead.head);
                if (hasHead.tail instanceof Cons) {
                    sb.append(", ");
                }
                self = hasHead.tail;
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public record Nil<T>() implements LL<T>
    {
        @Override
        public Nil<T> reverse() {
            return this;
        }

        @Override
        public Optional<T> headOption() {
            return Optional.empty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isPrefix(LL<T> other) {
            return true;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }
}

